/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.retrieval;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.simple.JSONAware;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;

class RetrievalFieldValue
implements JSONAware,
JSONStreamAware {
    static Pattern CAMEL_CASE_WORDS = Pattern.compile("([\\p{Lu}\\p{Lt}]?[\\p{Ll}\\p{Lm}\\p{Lo}\\d-]+|[\\p{Lu}\\p{Lt}])");
    String key;
    Object value;
    String fieldPrefixText;
    boolean indexed;

    static List<String> findCamelCaseWords(String text) {
        Matcher matcher = CAMEL_CASE_WORDS.matcher(text);
        ArrayList<String> words = new ArrayList<String>();
        while (matcher.find()) {
            words.add(matcher.group(0));
        }
        return words;
    }

    static String camelCaseToSpacedWords(String text) {
        return RetrievalFieldValue.findCamelCaseWords(text).stream().map(String::toLowerCase).collect(Collectors.joining(" "));
    }

    RetrievalFieldValue(String key, Object value, String fieldPrefixText, boolean indexed) {
        this.key = RetrievalFieldValue.camelCaseToSpacedWords(key);
        this.value = value;
        this.fieldPrefixText = fieldPrefixText;
        this.indexed = indexed;
    }

    void addValue(Object value) {
        if (this.value instanceof List) {
            List list = (List)this.value;
            if (!list.contains(value)) {
                list.add(value);
            }
        } else if (!this.value.equals(value)) {
            ArrayList<Object> replacedValue = new ArrayList<Object>(2);
            replacedValue.add(this.value);
            replacedValue.add(value);
            this.value = replacedValue;
        }
    }

    List<Object> getValueAsList() {
        if (this.value instanceof List) {
            return (List)this.value;
        }
        return Collections.singletonList(this.value);
    }

    String getKeyText() {
        return this.fieldPrefixText.replace("{}", this.key);
    }

    boolean isIndexed() {
        return this.indexed;
    }

    public String toJSONString() {
        return JSONValue.toJSONString((Object)this.value);
    }

    public void writeJSONString(Writer writer) throws IOException {
        JSONValue.writeJSONString((Object)this.value, (Writer)writer);
    }
}

