/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.retrieval;

import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalFieldValue;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalPlugin;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalResult;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalStore;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.ValuesUtil;
import com.ontotext.trree.sdk.HealthCheckable;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.ServerErrorException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;

public class RetrievalDriver
implements HealthCheckable {
    private static final int RETRIEVAL_ID_LENGTH_LIMIT = 1024;
    private final Logger logger;
    private final String indexName;
    private final AtomicBoolean retrievalTransactionIsActive = new AtomicBoolean();
    private final AtomicLong numDocumentsWrittenInTransaction = new AtomicLong();
    private final RetrievalStore store;
    private String baseUrl;
    private String authorization;
    private long bulkUpdateBatchSize;
    private JSONArray transactionDocuments;
    private JSONArray transactionDeletes;
    CloseableHttpClient httpClient;

    RetrievalDriver(RetrievalPlugin plugin, RetrievalStore store, String indexName, Options options) {
        this.store = store;
        this.logger = plugin.getLogger();
        this.indexName = indexName;
        this.updateOptions(options);
        this.httpClient = HttpClientBuilder.create().build();
    }

    private void beginInternal() {
        if (this.store.isTestingTransaction() && this.retrievalTransactionIsActive.compareAndSet(false, true)) {
            this.transactionDocuments = new JSONArray();
            this.transactionDeletes = new JSONArray();
        }
    }

    void begin() {
        this.retrievalTransactionIsActive.set(false);
        this.numDocumentsWrittenInTransaction.set(0L);
    }

    void commit() {
        this.flush();
        this.cleanup();
    }

    private void flushIfNeeded() {
        if (this.transactionDeletes != null && (long)this.transactionDeletes.size() >= this.bulkUpdateBatchSize || this.transactionDocuments != null && (long)this.transactionDocuments.size() >= this.bulkUpdateBatchSize) {
            this.flush();
        }
    }

    void flush() {
        JSONObject payload;
        if (this.transactionDeletes != null && !this.transactionDeletes.isEmpty()) {
            payload = new JSONObject();
            payload.put((Object)"ids", (Object)this.transactionDeletes);
            this.executeRequest("delete", "DELETE", (JSONAware)payload);
            this.transactionDeletes = new JSONArray();
        }
        if (this.transactionDocuments != null && !this.transactionDocuments.isEmpty()) {
            payload = new JSONObject();
            payload.put((Object)"documents", (Object)this.transactionDocuments);
            JSONObject result = this.executeRequest("upsert", "POST", (JSONAware)payload);
            this.transactionDocuments = new JSONArray();
        }
    }

    void rollback() {
        this.cleanup();
    }

    void cleanup() {
        this.transactionDocuments = null;
        this.transactionDeletes = null;
    }

    void delete(String uri) {
        if (this.store.isTestingTransaction()) {
            this.beginInternal();
            this.transactionDeletes.add((Object)uri);
            this.flushIfNeeded();
        }
    }

    void deleteAll() {
        if (this.store.isTestingTransaction()) {
            this.beginInternal();
            this.flush();
            JSONObject payload = new JSONObject();
            payload.put((Object)"delete_all", (Object)true);
            this.executeRequest("delete", "DELETE", (JSONAware)payload);
        }
    }

    boolean index(String uri, Map<String, RetrievalFieldValue> document) {
        Set<String> fieldNames = document.keySet();
        if (fieldNames.size() == 1 && fieldNames.contains("metadata")) {
            this.logger.warn("[{}] Document contains only metadata, skipping it: {}", (Object)this.store.getName(), (Object)uri);
            return false;
        }
        if (uri.length() <= 1024) {
            if (this.store.isTestingTransaction()) {
                this.beginInternal();
                String text = this.toText(document, 0);
                RetrievalFieldValue metadata = document.get("metadata");
                JSONObject jsonDocument = this.toJsonDocument(uri, text, metadata);
                this.transactionDocuments.add((Object)jsonDocument);
                this.flushIfNeeded();
            }
            this.numDocumentsWrittenInTransaction.incrementAndGet();
        } else {
            this.logger.warn("[{}] Skipping document with id longer than {} characters: {}", new Object[]{this.indexName, 1024, uri});
        }
        return true;
    }

    RetrievalResult query(MasterResultIterator mri) {
        try {
            JSONObject query;
            String queryString = mri.getQueryString();
            if (queryString.stripLeading().startsWith("{")) {
                query = (JSONObject)new JSONParser().parse(queryString);
            } else {
                JSONObject query0 = new JSONObject();
                query0.put((Object)"query", (Object)queryString);
                if (mri.getSearchOptions().limit > 0) {
                    query0.put((Object)"top_k", (Object)mri.getSearchOptions().limit);
                }
                query = new JSONObject();
                query.put((Object)"queries", Collections.singletonList(query0));
            }
            JSONObject result = this.executeRequest("query", "POST", (JSONAware)query);
            return new RetrievalResult(result);
        }
        catch (ParseException e) {
            throw new ConnectorUserException("Unable to parse query", (Throwable)e);
        }
    }

    void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }

    public HealthResult runHealthCheck() {
        return new HealthResult(this.indexName, HealthResult.Status.GREEN, "OK");
    }

    void updateOptions(Options options) {
        this.bulkUpdateBatchSize = (Long)options.getValue(RetrievalPlugin.BULK_UPDATE_BATCH_SIZE);
        Object url = (String)options.getValue(RetrievalPlugin.RETRIEVAL_URL);
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        this.baseUrl = url;
        String bearerToken = (String)options.getValue(RetrievalPlugin.RETRIEVAL_BEARER);
        this.authorization = bearerToken != null ? "Bearer " + bearerToken : null;
    }

    long getNumberOfDocumentsInTransaction() {
        return this.numDocumentsWrittenInTransaction.get();
    }

    private JSONObject toJsonDocument(String id, String text, RetrievalFieldValue metadata) {
        JSONObject document = new JSONObject();
        document.put((Object)"id", (Object)id);
        if (metadata != null) {
            this.fixMetadata(metadata);
            document.put((Object)"metadata", (Object)metadata);
        }
        document.put((Object)"text", (Object)text);
        return document;
    }

    private void fixMetadata(RetrievalFieldValue metadata) {
        RetrievalFieldValue createdAt;
        if (metadata.value instanceof Map && (createdAt = (RetrievalFieldValue)((Map)metadata.value).get("created_at")) != null && createdAt.value instanceof String) {
            try {
                ValuesUtil.INSTANCE.xsdTemporalAsISO((String)createdAt.value, XSD.DATETIME);
            }
            catch (IllegalArgumentException e) {
                try {
                    createdAt.value = ValuesUtil.INSTANCE.xsdTemporalAsISO((String)createdAt.value, XSD.DATE) + "T00:00:00Z";
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private String toText(Map<String, RetrievalFieldValue> document, int level) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ".repeat(level);
        RetrievalFieldValue subject = document.get("subject");
        if (subject != null && subject.isIndexed()) {
            for (Object value : subject.getValueAsList()) {
                sb.append(indent);
                sb.append(value);
                sb.append(":\n");
            }
        }
        Iterator<Map.Entry<String, RetrievalFieldValue>> iter = document.entrySet().iterator();
        while (iter.hasNext()) {
            RetrievalFieldValue fieldValue;
            Map.Entry<String, RetrievalFieldValue> e = iter.next();
            String key = e.getKey();
            if (key.equals("subject") || key.equals("metadata") || key.equals("text") || !(fieldValue = e.getValue()).isIndexed()) continue;
            String keyText = fieldValue.getKeyText();
            for (Object v : fieldValue.getValueAsList()) {
                sb.append(indent);
                sb.append("- ");
                sb.append(keyText);
                if (v instanceof Map) {
                    sb.append(":\n");
                    sb.append(this.toText((Map)v, level + 1));
                    continue;
                }
                sb.append(" ");
                sb.append(v);
                if (level == 0 || !iter.hasNext()) {
                    sb.append(".");
                } else {
                    sb.append(";");
                }
                sb.append("\n");
            }
        }
        RetrievalFieldValue text = document.get("text");
        if (text != null && text.isIndexed()) {
            for (Object t : text.getValueAsList()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(indent);
                sb.append(t);
            }
        }
        return sb.toString();
    }

    private JSONObject executeRequest(String url, String method, JSONAware data) {
        JSONObject jSONObject;
        block14: {
            Object request;
            if ("POST".equals(method)) {
                request = new HttpPost(url);
            } else if ("DELETE".equals(method)) {
                request = new HttpEntityEnclosingRequestBase(this){

                    public String getMethod() {
                        return "DELETE";
                    }
                };
            } else {
                throw new IllegalArgumentException();
            }
            request.setURI(URI.create(this.baseUrl).resolve(url));
            request.setHeader("Accept", "application/json");
            request.setHeader("Content-Type", "application/json");
            if (this.authorization != null) {
                request.setHeader("Authorization", this.authorization);
            }
            request.setEntity((HttpEntity)new StringEntity(data.toJSONString(), StandardCharsets.UTF_8));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode > 299) {
                    throw new ServerErrorException("Unable to execute request: " + String.valueOf(response.getStatusLine()));
                }
                jSONObject = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
                if (response == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            response.close();
        }
        return jSONObject;
    }
}

