/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesContentType;
import com.azure.ai.openai.responses.models.ResponsesOutputTextAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ResponsesOutputContentText
extends ResponsesContent {
    private ResponsesContentType type = ResponsesContentType.OUTPUT_TEXT;
    private final String text;
    private final List<ResponsesOutputTextAnnotation> annotations;

    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public List<ResponsesOutputTextAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesOutputContentText fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesOutputContentText)jsonReader.readObject(reader -> {
            String text = null;
            List annotations = null;
            ResponsesContentType type = ResponsesContentType.OUTPUT_TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    annotations = reader.readArray(reader1 -> ResponsesOutputTextAnnotation.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesOutputContentText deserializedResponsesOutputContentText = new ResponsesOutputContentText(text, annotations);
            deserializedResponsesOutputContentText.type = type;
            return deserializedResponsesOutputContentText;
        });
    }

    public ResponsesOutputContentText(String text, List<ResponsesOutputTextAnnotation> annotations) {
        this.text = text;
        this.annotations = annotations;
    }
}

