/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureGroundingEnhancementCoordinatePoint;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureGroundingEnhancementLineSpan
implements JsonSerializable<AzureGroundingEnhancementLineSpan> {
    private final String text;
    private final int offset;
    private final int length;
    private final List<AzureGroundingEnhancementCoordinatePoint> polygon;

    private AzureGroundingEnhancementLineSpan(String text, int offset, int length, List<AzureGroundingEnhancementCoordinatePoint> polygon) {
        this.text = text;
        this.offset = offset;
        this.length = length;
        this.polygon = polygon;
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public List<AzureGroundingEnhancementCoordinatePoint> getPolygon() {
        return this.polygon;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureGroundingEnhancementLineSpan fromJson(JsonReader jsonReader) throws IOException {
        return (AzureGroundingEnhancementLineSpan)jsonReader.readObject(reader -> {
            String text = null;
            int offset = 0;
            int length = 0;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    offset = reader.getInt();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    length = reader.getInt();
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> AzureGroundingEnhancementCoordinatePoint.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureGroundingEnhancementLineSpan(text, offset, length, polygon);
        });
    }
}

