/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.ontotext.graphdb.raft.security.SecurityConfig;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import javax.net.ssl.SSLSession;

public class SSLInterceptor
implements ServerInterceptor {
    public static final Context.Key<SSLSession> SSL_SESSION_CONTEXT = Context.key((String)"SSLSession");
    private final boolean certificateIsRequired = SecurityConfig.INSTANCE.isSecurityEnabled();

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        SSLSession sslSession = (SSLSession)call.getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
        if (sslSession == null) {
            if (this.certificateIsRequired) {
                throw new IllegalArgumentException("TLS is required when cluster security is enabled.");
            }
            return next.startCall(call, headers);
        }
        return Contexts.interceptCall((Context)Context.current().withValue(SSL_SESSION_CONTEXT, (Object)sslSession), call, (Metadata)headers, next);
    }
}

