/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.security;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import com.ontotext.graphdb.security.TokenManager;
import io.grpc.Context;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class AuthenticatorInterceptor
implements ServerInterceptor {
    public static final String WRONG_RECIPIENT = "Wrong recipient.";
    private static final Logger logger = LoggerFactory.getLogger(AuthenticatorInterceptor.class);
    private final TokenManager tokenManager;
    private final Supplier<String> rpcAddressSupplier;
    private String cachedRpcAddress;

    public AuthenticatorInterceptor(Supplier<String> rpcAddressSupplier) {
        this.tokenManager = TokenManager.getInstance();
        this.rpcAddressSupplier = rpcAddressSupplier;
    }

    @VisibleForTesting
    public AuthenticatorInterceptor(TokenManager tokenManager, Supplier<String> rpcAddressSupplier) {
        this.tokenManager = tokenManager;
        this.rpcAddressSupplier = rpcAddressSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String receiverAddress = (String)headers.get(SecurityUtil.RECIPIENT_ADDRESS);
        if (this.cachedRpcAddress == null) {
            this.cachedRpcAddress = this.rpcAddressSupplier.get();
        }
        if (receiverAddress != null && !receiverAddress.equals(this.cachedRpcAddress)) {
            throw this.unavailable(WRONG_RECIPIENT, receiverAddress, call);
        }
        String token = (String)headers.get(SecurityUtil.AUTHORIZATION_HEADER);
        if (token == null) {
            throw this.unauthorized("Unauthorized", call);
        }
        if (token.startsWith("GDB-Signature ") && this.verifyRequest(call, headers, token)) {
            Authentication authentication = this.getAuthenticationFromHeaders(headers);
            if (authentication == null) {
                return next.startCall(call, headers);
            }
            Context context = Context.current().fork();
            Context previous = context.attach();
            try {
                AuthenticationServerCallListener authenticationServerCallListener = new AuthenticationServerCallListener(next.startCall(call, headers), context, authentication);
                return authenticationServerCallListener;
            }
            finally {
                context.detach(previous);
            }
        }
        throw this.unauthorized("Invalid signature", call);
    }

    @NotNull
    private <ReqT, RespT> RuntimeException unauthorized(String message, ServerCall<ReqT, RespT> call) {
        String description = String.format("%s(%s) tried to call %s", call.getAuthority(), call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), call.getMethodDescriptor().getFullMethodName());
        logger.warn("{} {}", (Object)message, (Object)description);
        return new StatusRuntimeException(Status.UNAUTHENTICATED.withDescription(message).augmentDescription(description), null);
    }

    private <ReqT, RespT> RuntimeException unavailable(String message, String receiverAddress, ServerCall<ReqT, RespT> call) {
        String description = String.format("%s received a call(%s) for %s", this.cachedRpcAddress, call.getMethodDescriptor().getFullMethodName(), receiverAddress);
        logger.warn("{} {}", (Object)message, (Object)description);
        return new StatusRuntimeException(Status.UNAVAILABLE.withDescription(message).augmentDescription(description), null);
    }

    private <ReqT, RespT> boolean verifyRequest(ServerCall<ReqT, RespT> call, Metadata headers, String token) {
        return this.tokenManager.verifyRequest(call.getAuthority(), (String)headers.get(SecurityUtil.TIMESTAMP_HEADER), () -> SecurityUtil.createSummary(call, (String)headers.get(SecurityUtil.AUTH_CONTEXT_HEADER_USERNAME), (String)headers.get(SecurityUtil.USER_AUTHORITIES)), token);
    }

    private Authentication getAuthenticationFromHeaders(Metadata headers) {
        String username = (String)headers.get(SecurityUtil.AUTH_CONTEXT_HEADER_USERNAME);
        String userRolesAsString = (String)headers.get(SecurityUtil.USER_AUTHORITIES);
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)userRolesAsString)) {
            username = username.substring("user;".length());
            String credentials = "[CREDENTIALS]";
            String[] roles = userRolesAsString.split(",");
            List userRoles = Arrays.stream(roles).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
            User user = new User(username, credentials, userRoles);
            return new PreAuthenticatedAuthenticationToken((Object)user, (Object)credentials, userRoles);
        }
        return null;
    }

    private static class AuthenticationServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        private final Context context;
        private final Authentication authentication;

        public AuthenticationServerCallListener(ServerCall.Listener<ReqT> delegate, Context context, Authentication authentication) {
            super(delegate);
            this.context = context;
            this.authentication = authentication;
        }

        public void onMessage(ReqT message) {
            Context previous = this.context.attach();
            try {
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onMessage(message);
            }
            finally {
                SecurityContextHolder.clearContext();
                this.context.detach(previous);
            }
        }

        public void onReady() {
            Context previous = this.context.attach();
            try {
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onReady();
            }
            finally {
                SecurityContextHolder.clearContext();
                this.context.detach(previous);
            }
        }

        public void onComplete() {
            Context previous = this.context.attach();
            try {
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onComplete();
            }
            finally {
                SecurityContextHolder.clearContext();
                this.context.detach(previous);
            }
        }

        public void onCancel() {
            Context previous = this.context.attach();
            try {
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onCancel();
            }
            finally {
                SecurityContextHolder.clearContext();
                this.context.detach(previous);
            }
        }

        public void onHalfClose() {
            Context previous = this.context.attach();
            try {
                SecurityContextHolder.getContext().setAuthentication(this.authentication);
                super.onHalfClose();
            }
            finally {
                SecurityContextHolder.clearContext();
                this.context.detach(previous);
            }
        }
    }
}

