/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch.util;

import co.elastic.clients.elasticsearch._types.query_dsl.DecayFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldValueFactorScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionBoostMode;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RandomScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreFunction;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GraphDBFunctionScoreQuery
extends QueryBase
implements QueryVariant,
TaggedUnion<FunctionScore.Kind, Object>,
JsonpSerializable {
    @Nullable
    private final FunctionBoostMode boostMode;
    private final List<FunctionScore> functions;
    @Nullable
    private final Double maxBoost;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query query;
    @Nullable
    private final FunctionScoreMode scoreMode;
    @Nullable
    private final FunctionScore.Kind _kind;
    @Nullable
    private final Object _value;
    @Nullable
    private final Query filter;
    @Nullable
    private final Double weight;
    public static final JsonpDeserializer<GraphDBFunctionScoreQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GraphDBFunctionScoreQuery::setupGraphDBFunctionScoreQueryDeserializer);

    private GraphDBFunctionScoreQuery(Builder builder) {
        super((QueryBase.AbstractBuilder)builder);
        this.boostMode = builder.boostMode;
        this.functions = ApiTypeHelper.unmodifiable(builder.functions);
        this.maxBoost = builder.maxBoost;
        this.minScore = builder.minScore;
        this.query = builder.query;
        this.scoreMode = builder.scoreMode;
        if (builder._value != null) {
            this._kind = (FunctionScore.Kind)ApiTypeHelper.requireNonNull((Object)builder._kind, (Object)((Object)builder), (String)"<variant kind>");
            this._value = ApiTypeHelper.requireNonNull((Object)builder._value, (Object)((Object)builder), (String)"<variant value>");
        } else {
            this._kind = null;
            this._value = null;
        }
        this.filter = builder.filter;
        this.weight = builder.weight;
    }

    public static GraphDBFunctionScoreQuery of(Function<Builder, ObjectBuilder<GraphDBFunctionScoreQuery>> fn) {
        return (GraphDBFunctionScoreQuery)((Object)fn.apply(new Builder()).build());
    }

    @Nullable
    public final FunctionScore.Kind _kind() {
        return this._kind;
    }

    @Nullable
    public final Object _get() {
        return this._value;
    }

    public Query.Kind _queryKind() {
        return Query.Kind.FunctionScore;
    }

    @Nullable
    public final FunctionBoostMode boostMode() {
        return this.boostMode;
    }

    public final List<FunctionScore> functions() {
        return this.functions;
    }

    @Nullable
    public final Double maxBoost() {
        return this.maxBoost;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final FunctionScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Double weight() {
        return this.weight;
    }

    public boolean isExp() {
        return this._kind == FunctionScore.Kind.Exp;
    }

    public DecayFunction exp() {
        return (DecayFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.Exp);
    }

    public boolean isGauss() {
        return this._kind == FunctionScore.Kind.Gauss;
    }

    public DecayFunction gauss() {
        return (DecayFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.Gauss);
    }

    public boolean isLinear() {
        return this._kind == FunctionScore.Kind.Linear;
    }

    public DecayFunction linear() {
        return (DecayFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.Linear);
    }

    public boolean isFieldValueFactor() {
        return this._kind == FunctionScore.Kind.FieldValueFactor;
    }

    public FieldValueFactorScoreFunction fieldValueFactor() {
        return (FieldValueFactorScoreFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.FieldValueFactor);
    }

    public boolean isRandomScore() {
        return this._kind == FunctionScore.Kind.RandomScore;
    }

    public RandomScoreFunction randomScore() {
        return (RandomScoreFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.RandomScore);
    }

    public boolean isScriptScore() {
        return this._kind == FunctionScore.Kind.ScriptScore;
    }

    public ScriptScoreFunction scriptScore() {
        return (ScriptScoreFunction)TaggedUnionUtils.get((TaggedUnion)this, (Enum)FunctionScore.Kind.ScriptScore);
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.boostMode != null) {
            generator.writeKey("boost_mode");
            this.boostMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.functions)) {
            generator.writeKey("functions");
            generator.writeStartArray();
            for (FunctionScore item0 : this.functions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxBoost != null) {
            generator.writeKey("max_boost");
            generator.write(this.maxBoost.doubleValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write(this.weight.doubleValue());
        }
        if (this._value != null) {
            generator.writeKey(this._kind.jsonValue());
            if (this._value instanceof JsonpSerializable) {
                ((JsonpSerializable)this._value).serialize(generator, mapper);
            }
        }
    }

    protected static void setupGraphDBFunctionScoreQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::boostMode, (JsonpDeserializer)FunctionBoostMode._DESERIALIZER, "boost_mode");
        op.add(Builder::functions, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)FunctionScore._DESERIALIZER), "functions");
        op.add(Builder::maxBoost, JsonpDeserializer.doubleDeserializer(), "max_boost");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::scoreMode, (JsonpDeserializer)FunctionScoreMode._DESERIALIZER, "score_mode");
        op.add(Builder::exp, DecayFunction._DESERIALIZER, "exp");
        op.add(Builder::gauss, DecayFunction._DESERIALIZER, "gauss");
        op.add(Builder::linear, DecayFunction._DESERIALIZER, "linear");
        op.add(Builder::fieldValueFactor, FieldValueFactorScoreFunction._DESERIALIZER, "field_value_factor");
        op.add(Builder::randomScore, RandomScoreFunction._DESERIALIZER, "random_score");
        op.add(Builder::scriptScore, ScriptScoreFunction._DESERIALIZER, "script_score");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GraphDBFunctionScoreQuery> {
        @Nullable
        private FunctionBoostMode boostMode;
        @Nullable
        private List<FunctionScore> functions;
        @Nullable
        private Double maxBoost;
        @Nullable
        private Double minScore;
        @Nullable
        private Query query;
        @Nullable
        private FunctionScoreMode scoreMode;
        private FunctionScore.Kind _kind;
        private Object _value;
        @Nullable
        private Query filter;
        @Nullable
        private Double weight;

        public final Builder boostMode(@Nullable FunctionBoostMode value) {
            this.boostMode = value;
            return this;
        }

        public final Builder functions(List<FunctionScore> list) {
            this.functions = Builder._listAddAll(this.functions, list);
            return this;
        }

        public final Builder functions(FunctionScore value, FunctionScore ... values) {
            this.functions = Builder._listAdd(this.functions, (Object)value, (Object[])values);
            return this;
        }

        public final Builder functions(Function<FunctionScore.Builder, ObjectBuilder<FunctionScore>> fn) {
            return this.functions((FunctionScore)fn.apply(new FunctionScore.Builder()).build(), new FunctionScore[0]);
        }

        public final Builder maxBoost(@Nullable Double value) {
            this.maxBoost = value;
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query((Query)fn.apply(new Query.Builder()).build());
        }

        public final Builder scoreMode(@Nullable FunctionScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter((Query)fn.apply(new Query.Builder()).build());
        }

        public final Builder weight(@Nullable Double value) {
            this.weight = value;
            return this;
        }

        protected Builder self() {
            return this;
        }

        public ContainerBuilder exp(DecayFunction v) {
            this._kind = FunctionScore.Kind.Exp;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder exp(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.exp((DecayFunction)fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder gauss(DecayFunction v) {
            this._kind = FunctionScore.Kind.Gauss;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder gauss(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.gauss((DecayFunction)fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder linear(DecayFunction v) {
            this._kind = FunctionScore.Kind.Linear;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder linear(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.linear((DecayFunction)fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder fieldValueFactor(FieldValueFactorScoreFunction v) {
            this._kind = FunctionScore.Kind.FieldValueFactor;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder fieldValueFactor(Function<FieldValueFactorScoreFunction.Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
            return this.fieldValueFactor((FieldValueFactorScoreFunction)fn.apply(new FieldValueFactorScoreFunction.Builder()).build());
        }

        public ContainerBuilder randomScore(RandomScoreFunction v) {
            this._kind = FunctionScore.Kind.RandomScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder randomScore(Function<RandomScoreFunction.Builder, ObjectBuilder<RandomScoreFunction>> fn) {
            return this.randomScore((RandomScoreFunction)fn.apply(new RandomScoreFunction.Builder()).build());
        }

        public ContainerBuilder scriptScore(ScriptScoreFunction v) {
            this._kind = FunctionScore.Kind.ScriptScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptScore(Function<ScriptScoreFunction.Builder, ObjectBuilder<ScriptScoreFunction>> fn) {
            return this.scriptScore((ScriptScoreFunction)fn.apply(new ScriptScoreFunction.Builder()).build());
        }

        public GraphDBFunctionScoreQuery build() {
            this._checkSingleUse();
            return new GraphDBFunctionScoreQuery(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<GraphDBFunctionScoreQuery> {
            public final ContainerBuilder filter(@Nullable Query value) {
                Builder.this.filter = value;
                return this;
            }

            public final ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.filter((Query)fn.apply(new Query.Builder()).build());
            }

            public final ContainerBuilder weight(@Nullable Double value) {
                Builder.this.weight = value;
                return this;
            }

            public GraphDBFunctionScoreQuery build() {
                return Builder.this.build();
            }
        }
    }
}

