/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.ClassNameValidator;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchIndexExistValidator;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchStore;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchUrlValidation;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.RequestContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;

public class ElasticsearchPlugin
extends ExternalSyncPlugin {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("external-sync-elasticsearch-option-description", Locale.getDefault());
    static final String ELASTICSEARCH_NODE_PARAM_NAME = "elasticsearchNode";
    private static final String CREATE_SETTINGS_PARAM_NAME = "indexCreateSettings";
    public static final Option<String> ELASTICSEARCH_NODE = Option.string((String)"elasticsearchNode", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new ElasticsearchUrlValidation()).withValidator((Validator)new ElasticsearchIndexExistValidator()).required().updatable().build();
    private static final String MANAGE_MAPPING_NAME = "manageMapping";
    static final Option<Boolean> MANAGE_MAPPING = Option.flag((String)"manageMapping", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build();
    private static final String MANAGE_INDEX_NAME = "manageIndex";
    static final Option<Boolean> MANAGE_INDEX = Option.flag((String)"manageIndex", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).build();
    static final Option<String> EMBEDDING_MODEL = Option.string((String)"embeddingModel", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    private static final String ELASTICSEARCH_CLUSTER_SNIFF_PARAM_NAME = "elasticsearchClusterSniff";
    static final Option<Boolean> ELASTICSEARCH_CLUSTER_SNIFF = Option.flag((String)"elasticsearchClusterSniff", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)true).updatable().build();
    private static final String BASIC_AUTH_USER_FIELD = "elasticsearchBasicAuthUser";
    static final Option<String> BASIC_AUTH_USER = Option.string((String)"elasticsearchBasicAuthUser", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    private static final String BASIC_AUTH_PASSWORD_FIELD = "elasticsearchBasicAuthPassword";
    static final Option<String> BASIC_AUTH_PASSWORD = Option.string((String)"elasticsearchBasicAuthPassword", (ResourceBundle)RESOURCE_BUNDLE).updatable().build();
    static final Option<Long> BULK_UPDATE_BATCH_SIZE = Option.longNumber((String)"bulkUpdateBatchSize", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)5000L).updatable().build();
    static final Option<String> AUTHENTICATION_CONFIGURATOR_CLASS = Option.string((String)"authenticationConfiguratorClass", (ResourceBundle)RESOURCE_BUNDLE).withValidator((Validator)new ClassNameValidator()).updatable().build();
    private static final String ELASTICSEARCH_CLUSTER_PARAM_NAME = "elasticsearchCluster";
    static final Option<String> ELASTICSEARCH_CLUSTER = Option.string((String)"elasticsearchCluster", (ResourceBundle)RESOURCE_BUNDLE).deprecated().build();
    private static final String CLIENT_OPTIONS_PARAM_NAME = "elasticsearchClientOptions";
    static final Option<Map<String, Object>> CLIENT_OPTIONS = Option.optionMap((String)"elasticsearchClientOptions", (ResourceBundle)RESOURCE_BUNDLE).deprecated().build();
    static final Option<Long> BULK_UPDATE_REQUEST_SIZE = Option.longNumber((String)"bulkUpdateRequestSize", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)0x500000L).updatable().deprecated().build();
    static final Option<Map<String, Object>> CREATE_SETTINGS = Option.jsonString((String)"indexCreateSettings", (ResourceBundle)RESOURCE_BUNDLE).build();
    private static final ImmutableList<Option<?>> OPTIONS = ImmutableList.builder().add(ElasticsearchPlugin.createFieldsOptionsElastic("fields", false, ElasticsearchPlugin.createFieldsOptionsElastic("objectFields", true, ElasticsearchPlugin.createFieldsOptionsElastic("objectFields", true, ElasticsearchPlugin.createFieldsOptionsElastic("objectFields", true, ElasticsearchPlugin.createFieldsOptionsElastic("objectFields", true, ElasticsearchPlugin.createFieldsOptionsElastic("objectFields", true, new Option[0]))))))).addAll((Iterable)DEFAULT_OPTIONS).add(ELASTICSEARCH_NODE).add(BASIC_AUTH_USER).add(BASIC_AUTH_PASSWORD).add(AUTHENTICATION_CONFIGURATOR_CLASS).add(ELASTICSEARCH_CLUSTER_SNIFF).add(MANAGE_INDEX).add(MANAGE_MAPPING).add(BULK_UPDATE_BATCH_SIZE).add(BULK_UPDATE_REQUEST_SIZE).add(CREATE_SETTINGS).add(ELASTICSEARCH_CLUSTER).add(CLIENT_OPTIONS).add(EMBEDDING_MODEL).build();

    private static Option<List<Option<?>>> createFieldsOptionsElastic(String optionName, boolean isNested, Option<?> ... options) {
        Option[] moreOptions = new Option[options.length + (isNested ? 6 : 5)];
        moreOptions[0] = Option.flag((String)"fielddata", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
        moreOptions[1] = Option.flag((String)"array", (ResourceBundle)RESOURCE_BUNDLE).defaultValue((Object)false).build();
        moreOptions[2] = Option.jsonString((String)"nativeSettings", (ResourceBundle)RESOURCE_BUNDLE).build();
        moreOptions[3] = Option.string((String)"analyzer", (ResourceBundle)RESOURCE_BUNDLE).build();
        moreOptions[4] = DOCUMENT_FILTER;
        if (isNested) {
            moreOptions[5] = START_FROM_PARENT;
        }
        System.arraycopy(options, 0, moreOptions, moreOptions.length - options.length, options.length);
        return ElasticsearchPlugin.createFieldsOptions((String)optionName, (Option[])moreOptions);
    }

    public String getName() {
        return "elasticsearch-connector";
    }

    protected ExternalStore openExistingStore(String storeName, Options storeOptions, PluginConnection pluginConnection) {
        return ElasticsearchStore.open(storeName, storeOptions, this, pluginConnection);
    }

    protected ExternalStore createNewStore(String storeName, Options options, PluginConnection pluginConnection, Entities entitiesForCreation) {
        return ElasticsearchStore.create(storeName, options, this, pluginConnection, entitiesForCreation);
    }

    public List<Option<?>> getAllOptions() {
        return OPTIONS;
    }

    protected String getURIComponent() {
        return "elasticsearch";
    }

    public String getShortName() {
        return "Elasticsearch";
    }

    public BindingSet postprocess(BindingSet bindings, RequestContext requestContext) {
        return super.postprocess(bindings, requestContext);
    }

    protected Set<String> getOptionsToRedactForUser() {
        return Set.of(ELASTICSEARCH_NODE_PARAM_NAME, BASIC_AUTH_USER_FIELD, BASIC_AUTH_PASSWORD_FIELD, "authenticationConfiguratorClass");
    }
}

