/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.elasticsearch;

import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchDriver;
import com.ontotext.trree.plugin.externalsync.impl.elasticsearch.ElasticsearchPlugin;
import java.net.UnknownHostException;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;

public interface ElasticClientSupplier {
    public RestClient createClient(@Nullable ElasticsearchDriver var1, @Nullable SniffOnFailureListener var2, Options var3, Logger var4) throws UnknownHostException;

    default public Sniffer createSniffer(RestClient restClient, ElasticsearchNodesSniffer.Scheme firstHostScheme) {
        return Sniffer.builder((RestClient)restClient).setNodesSniffer((NodesSniffer)new ElasticsearchNodesSniffer(restClient, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, firstHostScheme)).build();
    }

    default public ElasticsearchNodesSniffer.Scheme getDefaultScheme(Options options) {
        String nodes = (String)options.getValue(ElasticsearchPlugin.ELASTICSEARCH_NODE);
        String[] nodesSplit = nodes.split("[,;\\s]+");
        if (nodesSplit[0].toLowerCase().startsWith("https:")) {
            return ElasticsearchNodesSniffer.Scheme.HTTPS;
        }
        return ElasticsearchNodesSniffer.Scheme.HTTP;
    }

    default public CreateIndexRequest.Builder newCreateIndexRequest(String indexName) {
        return new CreateIndexRequest.Builder().index(indexName);
    }

    default public IndexOperation<?> newIndexOperation(Map<String, Object> content, String uri, String indexName) {
        return ((IndexOperation.Builder)((IndexOperation.Builder)new IndexOperation.Builder().index(indexName)).document(content).id(uri)).build();
    }
}

