/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxObjectRenderer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererEvent;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererListener;
import org.semanticweb.owlapi.manchestersyntax.renderer.RenderingDirector;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OWLObjectComparator;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    protected final OWLObjectComparator ooc;
    private final OWLOntology o;
    private final Set<AxiomType<?>> filteredAxiomTypes = Collections.singleton(AxiomType.SWRL_RULE);
    private final List<RendererListener> listeners = new ArrayList<RendererListener>();
    private final Predicate<OWLAxiom> props = ax -> ((OWLNaryPropertyAxiom)ax).properties().count() == 2L;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    private boolean renderExtensions = false;
    private boolean explicitXsdStrings;
    private OWLAxiomFilter axiomFilter = axiom -> true;
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    @Nullable
    private RendererEvent event;

    public ManchesterOWLSyntaxFrameRenderer(OWLOntology ontology, Writer writer, ShortFormProvider entityShortFormProvider) {
        this(ontology, false, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(OWLOntology ontology, boolean explicitXsdString, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, explicitXsdString, entityShortFormProvider);
        this.o = ontology;
        this.ooc = new OWLObjectComparator(entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(Collection<OWLOntology> ontologies, Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
        if (ontologies.size() != 1) {
            throw new OWLRuntimeException("Can only render one ontology");
        }
        this.o = ontologies.iterator().next();
        this.ooc = new OWLObjectComparator(entityShortFormProvider);
    }

    static <E> Collection<E> sortedSet() {
        return new TreeSet();
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void setOntologyIRIShortFormProvider(OntologyIRIShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public void writeOntology() throws OWLRendererException {
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader();
        this.o.annotationPropertiesInSignature().sorted(this.ooc).forEach(this::write);
        this.o.datatypesInSignature().sorted(this.ooc).forEach(this::write);
        this.o.objectPropertiesInSignature().sorted(this.ooc).forEach(prop -> {
            this.write((OWLObjectPropertyExpression)prop);
            OWLObjectPropertyExpression invProp = prop.getInverseProperty();
            if (this.o.axioms(invProp).count() > 0L) {
                this.write(invProp);
            }
        });
        this.o.dataPropertiesInSignature().sorted(this.ooc).forEach(this::write);
        this.o.classesInSignature().sorted(this.ooc).forEach(this::write);
        this.o.individualsInSignature().sorted(this.ooc).forEach(this::write);
        this.o.referencedAnonymousIndividuals().sorted(this.ooc).forEach(this::write);
        this.event = new RendererEvent(this, (OWLObject)this.o);
        this.o.axioms(AxiomType.DISJOINT_CLASSES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.classExpressions(), ManchesterOWLSyntax.DISJOINT_CLASSES));
        this.o.axioms(AxiomType.EQUIVALENT_CLASSES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.classExpressions(), ManchesterOWLSyntax.EQUIVALENT_CLASSES));
        this.o.axioms(AxiomType.DISJOINT_OBJECT_PROPERTIES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.properties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES));
        this.o.axioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.properties(), ManchesterOWLSyntax.EQUIVALENT_PROPERTIES));
        this.o.axioms(AxiomType.DISJOINT_DATA_PROPERTIES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.properties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES));
        this.o.axioms(AxiomType.EQUIVALENT_DATA_PROPERTIES).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.properties(), ManchesterOWLSyntax.EQUIVALENT_PROPERTIES));
        this.o.axioms(AxiomType.DIFFERENT_INDIVIDUALS).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.individuals(), ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, true));
        this.o.axioms(AxiomType.SAME_INDIVIDUAL).sorted(this.ooc).forEach(ax -> this.writeMoreThanTwo((OWLAxiom)ax, ax.individuals(), ManchesterOWLSyntax.SAME_INDIVIDUAL, true));
        this.o.axioms(AxiomType.SWRL_RULE).sorted(this.ooc).forEach(rule -> this.writeSection(ManchesterOWLSyntax.RULE, Collections.singleton(rule).iterator(), ", ", false));
        this.filtersort(this.o.axioms(AxiomType.SUBCLASS_OF), a -> ((OWLSubClassOfAxiom)a).isGCI()).collect(Collectors.groupingBy(OWLSubClassOfAxiom::getSubClass)).forEach(this::write);
        this.flush();
    }

    protected <T> void writeMoreThanTwo(OWLAxiom ax, Stream<T> stream, ManchesterOWLSyntax section, boolean writeTwoIfAnnotated) {
        List individuals = OWLAPIStreamUtils.asList(stream);
        if (individuals.size() > 2 || writeTwoIfAnnotated && individuals.size() == 2 && !ax.annotationsAsList().isEmpty()) {
            SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
            map.put(individuals, ax);
            this.writeSection(section, map, ",", false);
        }
    }

    protected <T> void writeMoreThanTwo(OWLAxiom ax, Stream<T> stream, ManchesterOWLSyntax section) {
        List individuals = OWLAPIStreamUtils.asList(stream);
        if (individuals.size() > 2) {
            SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
            map.put(individuals, ax);
            this.writeSection(section, map, ",", false);
        }
    }

    public void writeOntologyHeader() {
        this.event = new RendererEvent(this, (OWLObject)this.o);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!this.o.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(((IRI)this.o.getOntologyID().getOntologyIRI().get()).toString());
            this.writeNewLine();
            this.pushTab(indent);
            Optional versionIRI = this.o.getOntologyID().getVersionIRI();
            if (versionIRI.isPresent()) {
                this.writeFullURI(((IRI)versionIRI.get()).toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        this.o.importsDeclarations().sorted().forEach(this::writeImports);
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, this.o.annotations().iterator(), ",", true);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    protected void writeImports(OWLImportsDeclaration decl) {
        this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
        this.write(ManchesterOWLSyntax.IMPORT.toString());
        this.write(":");
        this.writeSpace();
        this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
        this.writeFullURI(decl.getIRI().toString());
        this.writeNewLine();
        this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        Map<String, String> prefixMap = prov.getPrefixName2PrefixMap();
        prefixMap.entrySet().stream().sorted((o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey())).forEach(value -> {
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write((String)value.getKey());
            this.write(" ");
            this.writeFullURI((String)value.getValue());
            this.writeNewLine();
        });
        if (!prefixMap.containsKey(":")) {
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": : ");
            this.writeFullURI(this.o.getOntologyID().getOntologyIRI().map(IRI::toString).orElse(this.o.getOntologyID().getDefaultDocumentIRI().map(IRI::toString).orElse("urn:absoluteiri:defaultvalue#")));
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Collection<OWLAxiom> writeFrame(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write((OWLIndividual)entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return Collections.emptySet();
    }

    protected <T extends OWLAxiom> Stream<T> filtersort(Stream<T> s) {
        return s.filter(this::isDisplayed).sorted((Comparator<OWLAxiom>)this.ooc);
    }

    protected <T extends OWLAxiom> Stream<T> filtersort(Stream<T> s, Predicate<OWLAxiom> extra) {
        return s.filter(this::isDisplayed).filter(extra).sorted((Comparator<OWLAxiom>)this.ooc);
    }

    private void write(OWLClassExpression superClass, List<OWLSubClassOfAxiom> axs) {
        this.writeEntityStart(ManchesterOWLSyntax.CLASS, (OWLObject)superClass);
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            SectionMap<Object, OWLAxiom> superclasses = new SectionMap<Object, OWLAxiom>();
            this.filtersort(axs.stream()).forEach(ax -> superclasses.put(ax.getSuperClass(), (OWLAxiom)ax));
            this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true);
        }
    }

    public Collection<OWLAxiom> write(OWLClass cls) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, (OWLObject)cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            SectionMap<Object, OWLAxiom> equivalentClasses = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.equivalentClassesAxioms(cls), ax -> ((OWLEquivalentClassesAxiom)ax).classExpressions().count() == 2L).forEach(ax -> {
                ax.getClassExpressionsMinus(new OWLClassExpression[]{cls}).forEach(c -> equivalentClasses.put(c, (OWLAxiom)ax));
                axioms.add((OWLAxiom)ax);
            });
            equivalentClasses.remove(cls);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true);
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            SectionMap<Object, OWLAxiom> superclasses = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.subClassAxiomsForSubClass(cls)).forEach(ax -> {
                superclasses.put(ax.getSuperClass(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true);
            if (this.renderExtensions) {
                SectionMap<Object, OWLAxiom> subClasses = new SectionMap<Object, OWLAxiom>();
                this.filtersort(this.o.subClassAxiomsForSuperClass(cls)).forEach(ax -> {
                    subClasses.put(ax.getSubClass(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                });
                this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_UNION)) {
            this.filtersort(this.o.disjointUnionAxioms(cls)).forEach(ax -> {
                axioms.add((OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_UNION_OF, ax.classExpressions().iterator(), ", ", false);
            });
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            SectionMap<Object, OWLAxiom> disjointClasses = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.disjointClassesAxioms(cls)).forEach(ax -> {
                if (ax.classExpressions().count() == 2L) {
                    OWLClassExpression disjointWith = (OWLClassExpression)ax.getClassExpressionsMinus(new OWLClassExpression[]{cls}).iterator().next();
                    disjointClasses.put(disjointWith, (OWLAxiom)ax);
                }
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false);
            if (this.renderExtensions) {
                this.filtersort(this.o.disjointClassesAxioms(cls)).forEach(ax -> {
                    if (ax.classExpressions().count() > 2L) {
                        axioms.add((OWLAxiom)ax);
                        this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, ax.classExpressions().iterator(), ", ", false);
                    }
                });
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            this.filtersort(this.o.hasKeyAxioms(cls)).forEach(ax -> {
                SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
                map.put(OWLAPIStreamUtils.asList((Stream)ax.propertyExpressions()), (OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.HAS_KEY, map, ", ", true);
            });
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            SectionMap<Object, OWLAxiom> individuals = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.classAssertionAxioms((OWLClassExpression)cls), ax -> this.renderExtensions).forEach(ax -> {
                individuals.put(ax.getIndividual(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true);
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            HashSet rules = new HashSet();
            this.filtersort(this.o.axioms(AxiomType.SWRL_RULE)).forEach(rule -> {
                for (SWRLAtom atom : OWLAPIStreamUtils.asList((Stream)rule.head())) {
                    if (!atom.getPredicate().equals((Object)cls)) continue;
                    this.writeSection(ManchesterOWLSyntax.RULE, rules.iterator(), ", ", true);
                    break;
                }
            });
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    public Collection<OWLAxiom> write(OWLObjectPropertyExpression property) {
        SectionMap<Object, OWLAxiom> expressions;
        SectionMap<Object, OWLAxiom> properties;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            properties = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.objectSubPropertyAxiomsForSubProperty(property)).forEach(ax -> {
                properties.put(ax.getSuperProperty(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, properties, ",", true);
            if (this.renderExtensions) {
                SectionMap<Object, OWLAxiom> extproperties = new SectionMap<Object, OWLAxiom>();
                this.filtersort(this.o.objectSubPropertyAxiomsForSuperProperty(property)).forEach(ax -> {
                    extproperties.put(ax.getSubProperty(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                });
                this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, extproperties, ",", true);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            properties = new SectionMap();
            this.filtersort(this.o.equivalentObjectPropertiesAxioms(property), this.props).forEach(ax -> {
                properties.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, properties, ",", true);
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            properties = new SectionMap();
            this.filtersort(this.o.disjointObjectPropertiesAxioms(property), this.props).forEach(ax -> {
                properties.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, properties, ",", true);
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            this.filtersort(this.o.axioms(AxiomType.SUB_PROPERTY_CHAIN_OF), ax -> ((OWLSubPropertyChainOfAxiom)ax).getSuperProperty().equals((Object)property)).forEach(ax -> {
                SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
                map.put(ax.getPropertyChain(), (OWLAxiom)ax);
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, map, " o ", false);
                axioms.add((OWLAxiom)ax);
            });
        }
        SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
        if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
            this.filtersort(this.o.functionalObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
            this.filtersort(this.o.inverseFunctionalObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
            this.filtersort(this.o.symmetricObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.SYMMETRIC.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
            this.filtersort(this.o.transitiveObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.TRANSITIVE.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
            this.filtersort(this.o.reflexiveObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.REFLEXIVE.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
            this.filtersort(this.o.irreflexiveObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.IRREFLEXIVE.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
            this.filtersort(this.o.asymmetricObjectPropertyAxioms(property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.ASYMMETRIC.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
        }
        this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true);
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            expressions = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.objectPropertyDomainAxioms(property)).forEach(ax -> {
                expressions.put(ax.getDomain(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            expressions = new SectionMap();
            this.filtersort(this.o.objectPropertyRangeAxioms(property)).forEach(ax -> {
                expressions.put(ax.getRange(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true);
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            Collection properties2 = this.sortedCollection();
            this.filtersort(this.o.inverseObjectPropertyAxioms(property)).forEach(ax -> {
                if (ax.getFirstProperty().equals((Object)property)) {
                    properties2.add(ax.getSecondProperty());
                } else {
                    properties2.add(ax.getFirstProperty());
                }
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.INVERSE_OF, properties2.iterator(), ",", true);
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            Collection rules = this.sortedCollection();
            this.filtersort(this.o.axioms(AxiomType.SWRL_RULE)).forEach(rule -> {
                for (SWRLAtom atom : OWLAPIStreamUtils.asList((Stream)rule.head())) {
                    if (!atom.getPredicate().equals((Object)property)) continue;
                    rules.add(rule);
                    this.writeSection(ManchesterOWLSyntax.RULE, rules.iterator(), ",", true);
                    break;
                }
            });
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    public Collection<OWLAxiom> write(OWLDataProperty property) {
        SectionMap<Object, OWLAxiom> properties;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.functionalDataPropertyAxioms((OWLDataPropertyExpression)property)).forEach(ax -> {
                characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true);
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            SectionMap<Object, OWLAxiom> domains = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.dataPropertyDomainAxioms(property)).forEach(ax -> {
                domains.put(ax.getDomain(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true);
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            SectionMap<Object, OWLAxiom> ranges = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.dataPropertyRangeAxioms(property)).forEach(ax -> {
                ranges.put(ax.getRange(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true);
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            SectionMap<Object, OWLAxiom> supers = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.dataSubPropertyAxiomsForSubProperty(property)).forEach(ax -> {
                supers.put(ax.getSuperProperty(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true);
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            properties = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.equivalentDataPropertiesAxioms(property), this.props).forEach(ax -> {
                properties.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, properties, ",", true);
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            properties = new SectionMap();
            this.filtersort(this.o.disjointDataPropertiesAxioms(property), this.props).forEach(ax -> {
                properties.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            properties.remove(property);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, properties, ",", true);
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            ArrayList rules = new ArrayList();
            this.filtersort(this.o.axioms(AxiomType.SWRL_RULE)).forEach(rule -> {
                for (SWRLAtom atom : OWLAPIStreamUtils.asList((Stream)rule.head())) {
                    if (!atom.getPredicate().equals((Object)property)) continue;
                    this.writeSection(ManchesterOWLSyntax.RULE, rules.iterator(), "", true);
                    break;
                }
            });
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    public Collection<OWLAxiom> write(OWLIndividual individual) {
        Collection inds;
        List<OWLPropertyAssertionAxiom<?, ?>> assertions;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, (OWLObject)individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            SectionMap<Object, OWLAxiom> expressions = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.classAssertionAxioms(individual)).forEach(ax -> {
                expressions.put(ax.getClassExpression(), (OWLAxiom)ax);
                axioms.add((OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true);
        }
        if (!(assertions = Stream.of(this.o.objectPropertyAssertionAxioms(individual), this.o.negativeObjectPropertyAssertionAxioms(individual), this.o.dataPropertyAssertionAxioms(individual), this.o.negativeDataPropertyAssertionAxioms(individual)).flatMap(x -> x).sorted(this.ooc).collect(Collectors.toList())).isEmpty()) {
            this.handleAssertions(assertions);
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            inds = this.sortedCollection();
            this.filtersort(this.o.sameIndividualAxioms(individual)).forEach(ax -> {
                if (ax.getIndividualsAsList().size() == 2 && ax.annotationsAsList().isEmpty()) {
                    OWLAPIStreamUtils.add((Collection)inds, (Stream)ax.individuals());
                    axioms.add((OWLAxiom)ax);
                }
            });
            inds.remove(individual);
            this.writeSection(ManchesterOWLSyntax.SAME_AS, inds.iterator(), ",", true);
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            inds = this.sortedCollection();
            Collection nary = this.sortedCollection();
            this.filtersort(this.o.differentIndividualAxioms(individual)).forEach(ax -> {
                if (ax.getIndividualsAsList().size() == 2 && ax.annotationsAsList().isEmpty()) {
                    OWLAPIStreamUtils.add((Collection)inds, (Stream)ax.individuals());
                    axioms.add((OWLAxiom)ax);
                } else {
                    nary.add(ax);
                }
            });
            inds.remove(individual);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds.iterator(), ",", true);
            if (this.renderExtensions) {
                nary.forEach(ax -> this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ax.individuals().iterator(), ", ", false));
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    protected void handleAssertions(List<OWLPropertyAssertionAxiom<?, ?>> assertions) {
        this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
        this.writeSection(ManchesterOWLSyntax.FACTS);
        this.writeSpace();
        this.writeOntologiesList(this.o);
        this.incrementTab(1);
        this.writeNewLine();
        this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
        Iterator<OWLPropertyAssertionAxiom<?, ?>> it = assertions.iterator();
        while (it.hasNext()) {
            OWLPropertyAssertionAxiom<?, ?> ax = it.next();
            this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
            Iterator<OWLAnnotation> annos = ax.annotations().iterator();
            boolean isNotEmpty = annos.hasNext();
            if (isNotEmpty) {
                this.writeAnnotations(annos);
                this.pushTab(this.getIndent() + 1);
            }
            if (ax instanceof OWLNegativeDataPropertyAssertionAxiom || ax instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                this.write(ManchesterOWLSyntax.NOT);
                this.writeSpace();
            }
            ax.getProperty().accept((OWLObjectVisitor)this);
            this.writeSpace();
            this.writeSpace();
            ax.getObject().accept((OWLObjectVisitor)this);
            if (isNotEmpty) {
                this.popTab();
            }
            this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
            if (!it.hasNext()) continue;
            this.write(",");
            this.writeNewLine();
        }
        this.popTab();
        this.writeNewLine();
        this.writeNewLine();
    }

    public Collection<OWLAxiom> write(OWLDatatype datatype) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, (OWLObject)datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            Collection dataRanges = this.sortedCollection();
            this.o.datatypeDefinitions(datatype).filter(this::isDisplayed).forEach(ax -> {
                axioms.add((OWLAxiom)ax);
                dataRanges.add(ax.getDataRange());
            });
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges.iterator(), ",", true);
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    public Collection<OWLAxiom> write(SWRLRule rule) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>(1);
        if (this.o.containsAxiom((OWLAxiom)rule)) {
            this.writeSection(ManchesterOWLSyntax.RULE, CollectionFactory.createSet((Object)rule).iterator(), "", true);
            axioms.add((OWLAxiom)rule);
        }
        return axioms;
    }

    public Collection<OWLAxiom> write(OWLAnnotationProperty property) {
        Collection iris;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            Collection properties = this.sortedCollection();
            this.o.subAnnotationPropertyOfAxioms(property).filter(this::isDisplayed).forEach(ax -> properties.add(ax.getSuperProperty()));
            this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, properties.iterator(), ",", true);
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            iris = this.sortedCollection();
            this.o.annotationPropertyDomainAxioms(property).filter(this::isDisplayed).forEach(ax -> iris.add((IRI)ax.getDomain()));
            this.writeSection(ManchesterOWLSyntax.DOMAIN, iris.iterator(), ",", true);
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            iris = this.sortedCollection();
            this.o.annotationPropertyRangeAxioms(property).filter(this::isDisplayed).forEach(ax -> iris.add((IRI)ax.getRange()));
            this.writeSection(ManchesterOWLSyntax.RANGE, iris.iterator(), ",", true);
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Collection<OWLAnnotationAssertionAxiom> writeEntityStart(ManchesterOWLSyntax keyword, OWLObject entity) {
        Set annotations;
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        boolean resetTab = false;
        if (entity instanceof OWLEntity && !(annotations = this.o.declarationAxioms((OWLEntity)entity).flatMap(HasAnnotations::annotations).sorted().collect(Collectors.toSet())).isEmpty()) {
            this.incrementTab(4);
            this.writeNewLine();
            this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
            this.write(": ");
            this.pushTab(this.getIndent() + 1);
            Iterator annoIt = annotations.iterator();
            while (annoIt.hasNext()) {
                ((OWLAnnotation)annoIt.next()).accept((OWLObjectVisitor)this);
                if (!annoIt.hasNext()) continue;
                this.write(", ");
                this.writeNewLine();
            }
            this.popTab();
            this.popTab();
            this.incrementTab(2);
            this.writeNewLine();
            resetTab = true;
        }
        entity.accept((OWLObjectVisitor)this);
        if (resetTab) {
            this.popTab();
        }
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLAnonymousIndividual)entity));
        }
        return Collections.emptySet();
    }

    public Collection<OWLAnnotationAssertionAxiom> writeAnnotations(OWLAnnotationSubject subject) {
        Collection<OWLAnnotationAssertionAxiom> axioms = this.sortedCollection();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            SectionMap<Object, OWLAxiom> sectionMap = new SectionMap<Object, OWLAxiom>();
            this.filtersort(this.o.annotationAssertionAxioms(subject)).forEach(ax -> {
                axioms.add((OWLAnnotationAssertionAxiom)ax);
                sectionMap.put(ax.getAnnotation(), (OWLAxiom)ax);
            });
            this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true);
        }
        return axioms;
    }

    public void writeSection(ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    private void writeSection(ManchesterOWLSyntax keyword, SectionMap<Object, OWLAxiom> content, String delimeter, boolean newline) {
        String sec = keyword.toString();
        if (content.isNotEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, this.o)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(this.o);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Collection<Collection<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator<Collection<OWLAnnotation>> annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Collection<OWLAnnotation> annos = annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator<OWLAnnotation> annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            annoIt.next().accept((OWLObjectVisitor)this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept((OWLObjectVisitor)this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object object = listIt.next();
                            if (object instanceof OWLObject) {
                                ((OWLObject)object).accept((OWLObjectVisitor)this);
                            } else {
                                this.write(object.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(ManchesterOWLSyntax keyword, Iterator<?> content, String delimiter, boolean newline) {
        String sec = keyword.toString();
        if (content.hasNext() || this.renderingDirector.renderEmptyFrameSection(keyword, this.o)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(this.o);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            while (content.hasNext()) {
                Object obj = content.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept((OWLObjectVisitor)this);
                } else {
                    this.write(obj.toString());
                }
                if (content.hasNext()) {
                    this.write(delimiter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.frameRenderingPrepared(section, this.event));
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.frameRenderingStarted(section, this.event));
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.frameRenderingFinished(section, this.event));
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.sectionRenderingPrepared(section, this.event));
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.sectionRenderingStarted(section, this.event));
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.sectionRenderingFinished(section, this.event));
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.sectionItemPrepared(section, this.event));
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(l -> l.sectionItemFinished(section, this.event));
    }

    <E extends OWLObject> Collection<E> sortedCollection() {
        return new TreeSet(this.ooc);
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        DefaultRenderingDirector() {
        }

        @Override
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }

    private class SectionMap<O, V extends OWLAxiom> {
        private final Map<O, Collection<V>> object2Axioms = new LinkedHashMap<O, Collection<V>>();

        SectionMap() {
        }

        boolean isNotEmpty() {
            return !this.object2Axioms.isEmpty();
        }

        void put(O obj, V forAxiom) {
            Collection<Object> axioms = this.object2Axioms.get(obj);
            if (axioms == null) {
                axioms = ManchesterOWLSyntaxFrameRenderer.this.sortedCollection();
                this.object2Axioms.put(obj, axioms);
            }
            axioms.add(forAxiom);
        }

        void remove(O obj) {
            this.object2Axioms.remove(obj);
        }

        Collection<O> getSectionObjects() {
            return this.object2Axioms.keySet();
        }

        Collection<Collection<OWLAnnotation>> getAnnotationsForSectionObject(Object sectionObject) {
            Collection<V> axioms = this.object2Axioms.get(sectionObject);
            if (axioms == null) {
                return ManchesterOWLSyntaxFrameRenderer.sortedSet();
            }
            ArrayList<Collection<OWLAnnotation>> annos = new ArrayList<Collection<OWLAnnotation>>();
            axioms.forEach(ax -> annos.add(OWLAPIStreamUtils.asList(ax.annotations().sorted(ManchesterOWLSyntaxFrameRenderer.this.ooc))));
            return annos;
        }
    }
}

