/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.io.PrintWriter;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntax;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxStorerBase;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class DLSyntaxHTMLStorer
extends DLSyntaxStorerBase {
    protected final SimpleShortFormProvider sfp = new SimpleShortFormProvider();

    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof DLSyntaxHTMLDocumentFormat;
    }

    @Override
    protected String getRendering(final @Nullable OWLEntity subject, OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null");
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer(){

            @Override
            protected String renderEntity(OWLEntity entity) {
                String shortForm = DLSyntaxHTMLStorer.this.sfp.getShortForm((OWLEntity)OWLAPIPreconditions.checkNotNull((Object)entity, (String)"entity cannot be null"));
                if (entity.equals((Object)subject)) {
                    return shortForm;
                }
                return "<a href=\"#" + shortForm + "\">" + shortForm + "</a>";
            }

            @Override
            protected void write(DLSyntax keyword) {
                this.write(((DLSyntax)((Object)OWLAPIPreconditions.checkNotNull((Object)((Object)keyword), (String)"keyword cannot be null"))).toHTMLString());
            }
        };
        ren.setFocusedObject((OWLObject)subject);
        ren.setShortFormProvider((ShortFormProvider)this.sfp);
        return ren.render((OWLObject)axiom);
    }

    @Override
    protected void beginWritingOntology(OWLOntology ontology, PrintWriter writer) {
        this.checkOntologyNotNull(ontology);
        this.checkWriterNotNull(writer);
        writer.println("<html>");
        writer.println("<body>");
        writer.println("<h1>Ontology: ");
        writer.print(ontology.getOntologyID());
        writer.println("</h1>");
    }

    protected void checkOntologyNotNull(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
    }

    protected void checkWriterNotNull(PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
    }

    protected void writeEntity(OWLEntity entity, PrintWriter writer) {
    }

    @Override
    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer) {
        this.checkOntologyNotNull(ontology);
        this.checkWriterNotNull(writer);
        writer.println("</body>");
        writer.println("</html>");
    }

    @Override
    protected void beginWritingAxiom(PrintWriter writer) {
        ((PrintWriter)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null")).println("<div class=\"axiombox\"> ");
    }

    @Override
    protected void endWritingAxiom(PrintWriter writer) {
        ((PrintWriter)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null")).println("</div>");
    }

    @Override
    protected void beginWritingAxioms(OWLEntity subject, PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        this.checkWriterNotNull(writer);
        writer.print("<h2><a name=\"");
        writer.print(this.sfp.getShortForm(subject));
        writer.print("\">");
        writer.print(subject.getIRI());
        writer.println("</a></h2>");
        writer.println("<div class=\"entitybox\">");
    }

    @Override
    protected void endWritingAxioms(PrintWriter writer) {
        writer.println("</div>");
    }

    @Override
    protected void beginWritingGeneralAxioms(PrintWriter writer) {
        writer.println("<div>");
    }

    @Override
    protected void endWritingGeneralAxioms(PrintWriter writer) {
        writer.println("</div>");
    }

    @Override
    protected void beginWritingUsage(int size, PrintWriter writer) {
        writer.println("<div class=\"usage\" style=\"margin-left: 60px; size: tiny\">");
        writer.println("<h3>Usages (" + size + ")</h3>");
    }

    @Override
    protected void endWritingUsage(PrintWriter writer) {
        writer.println("</div>");
    }
}

