/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.querymodel.And;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.In;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Not;
import com.ontotext.graphql.compiler.querymodel.NotEquals;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.Or;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.DataType;
import com.ontotext.graphql.compiler.querymodel.functions.IsBlank;
import com.ontotext.graphql.compiler.querymodel.functions.IsIri;
import com.ontotext.graphql.compiler.querymodel.functions.IsLiteral;
import com.ontotext.models.EnumValueDef;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class ScalarPropertyMismatchValidationStep
implements ValidationStep,
DisplayableValidation,
OffendingValidationDataRetrieval {
    public static final String NAME = "scalarPropertyMismatch";
    private static final Var SUBJECT = new Var("subject");
    private static final Var VALUE = new Var("value");
    private static final Var TYPENAME = new Var("type");
    private static final Var CONTEXT = new Var("context");
    private Rdf4jInputValueConverter valueConverter = new Rdf4jInputValueConverter();

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return propertyShape != null && !"id".equals(propertyShape.getName()) && !"name".equals(propertyShape.getName()) && propertyShape.isScalarType() && !propertyShape.isLiteral();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        List<SparqlNode> sparqlNodes = this.getMainSelection(schema, validation);
        PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
        SparqlNode filter = this.buildTypeFilter(property);
        sparqlNodes.add(filter);
        String question = ValidationStepUtil.createAskQuery(schema, sparqlNodes);
        if (ValidationStepUtil.ask(dataEndpoint, validation, question).isYes()) {
            sparqlNodes.remove(filter);
            Map<String, Long> counts = this.countOtherTypes(schema, validation, dataEndpoint, sparqlNodes, property);
            if (ValidationStepUtil.addRangeMismatchMessage(counts, validation, property)) {
                validation.setTaskStatus(Task.TaskStatus.WARN);
            }
        }
    }

    @NotNull
    private SparqlNode buildTypeFilter(PropertyShape property) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.hasIriType(property)) {
            filters.add(new Not((SparqlNode)new IsIri((SparqlNode)VALUE)));
        } else {
            filters.add(new Not((SparqlNode)new IsLiteral((SparqlNode)VALUE)));
            filters.add(new NotEquals((SparqlNode)new DataType((SparqlNode)VALUE), (SparqlNode)new Iri(property.getScalarType().getRdf())));
        }
        if (property.getScalarType().isEnum()) {
            filters.add(new Not((SparqlNode)new In((SparqlNode)VALUE, this.getEnumValues(property))));
        }
        Filter filter = filters.size() == 1 ? new Filter((SparqlNode)filters.get(0)) : new Filter((SparqlNode)new Or(filters));
        return filter;
    }

    private boolean hasIriType(PropertyShape property) {
        return "rdfs:Resource".equals(property.getScalarType().getRdf());
    }

    private Collection<Value> getEnumValues(PropertyShape property) {
        if (this.hasIriType(property)) {
            return property.getScalarType().getValues().stream().map(EnumValueDef::getValue).map(Object::toString).map(Iri::new).collect(Collectors.toList());
        }
        return property.getScalarType().getValues().stream().map(EnumValueDef::getName).map(enumName -> this.valueConverter.convert(enumName, property.getScalarType())).map(Literal::new).collect(Collectors.toList());
    }

    @Override
    public String getViewQuery(SomlSchema schema, ValidationTask validation) {
        SelectQuery query = this.buildViewQuery(schema, validation, false);
        query.setLimit(Long.valueOf(100L));
        return SparqlUtil.prettyPrint((String)query.toSparql());
    }

    @NotNull
    protected SelectQuery buildViewQuery(SomlSchema schema, ValidationTask validation, boolean lateral) {
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, SUBJECT);
        Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        PatternNode propertyMatch = PatternNode.createPattern((Value)SUBJECT, (Value)propertyPredicate, (Value)VALUE);
        PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
        if (lateral) {
            ArrayList<SparqlNode> subqueryNodes = new ArrayList<SparqlNode>();
            subqueryNodes.add((SparqlNode)propertyMatch);
            subqueryNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)CONTEXT).addNode((SparqlNode)propertyMatch)));
            subqueryNodes.add((SparqlNode)this.getMainCheck(property));
            SelectQuery query = ValidationStepUtil.createSelectQuery(schema, subqueryNodes);
            query.getProjectionSegment().add(SUBJECT);
            query.getProjectionSegment().add(VALUE);
            query.getProjectionSegment().add(TYPENAME);
            query.getProjectionSegment().add(CONTEXT);
            query.convertToSubSelect();
            query.setValues(new Values(SUBJECT));
            sparqlNodes.add((SparqlNode)query);
        } else {
            sparqlNodes.add((SparqlNode)propertyMatch);
            sparqlNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)CONTEXT).addNode((SparqlNode)propertyMatch)));
            sparqlNodes.add((SparqlNode)this.getMainCheck(property));
        }
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, sparqlNodes);
        query.getProjectionSegment().add(SUBJECT);
        query.getProjectionSegment().add(VALUE);
        query.getProjectionSegment().add(TYPENAME);
        query.getProjectionSegment().add(CONTEXT);
        return query;
    }

    @NotNull
    private List<SparqlNode> getMainSelection(SomlSchema schema, ValidationTask validation) {
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, SUBJECT);
        Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        PatternNode propertyMatch = PatternNode.createPattern((Value)SUBJECT, (Value)propertyPredicate, (Value)VALUE);
        sparqlNodes.add((SparqlNode)propertyMatch);
        return sparqlNodes;
    }

    @NotNull
    private Map<String, Long> countOtherTypes(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint, List<SparqlNode> sparqlNodes, PropertyShape property) {
        UnionCollection unionCollection = this.getMainCheck(property);
        sparqlNodes.add((SparqlNode)unionCollection);
        return ValidationStepUtil.executeCountAggregationQuery(schema, sparqlNodes, TYPENAME, dataEndpoint, validation);
    }

    @NotNull
    private UnionCollection getMainCheck(PropertyShape property) {
        UnionCollection unionCollection = new UnionCollection();
        if (this.hasIriType(property)) {
            unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsLiteral((SparqlNode)VALUE)), new Bind((SparqlNode)new DataType((SparqlNode)VALUE), (Value)TYPENAME)}));
        } else {
            unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new And(new SparqlNode[]{new IsLiteral((SparqlNode)VALUE), new NotEquals((SparqlNode)new DataType((SparqlNode)VALUE), (SparqlNode)new Iri(property.getScalarType().getRdf()))})), new Bind((SparqlNode)new DataType((SparqlNode)VALUE), (Value)TYPENAME)}));
            unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsIri((SparqlNode)VALUE)), new Bind((SparqlNode)Literal.asString((String)"iri"), (Value)TYPENAME)}));
        }
        if (property.getScalarType().isEnum()) {
            unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new Not((SparqlNode)new In((SparqlNode)VALUE, this.getEnumValues(property)))), new Bind((SparqlNode)Literal.asString((String)"unknownEnumValue"), (Value)TYPENAME)}));
        }
        unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsBlank((SparqlNode)VALUE)), new Bind((SparqlNode)Literal.asString((String)"blank"), (Value)TYPENAME)}));
        return unionCollection;
    }

    @Override
    public DataRetrievalResponse loadData(DataRetrievalRequest request) {
        SelectQuery query = this.buildViewQuery(request.getSchema(), request.getValidation(), true);
        DataRetrievalResponse response = new DataRetrievalResponse();
        ConsumingTupleQueryResultHandler resultHandler = new ConsumingTupleQueryResultHandler(ValidationStepUtil.readBindings(response::addResultEntry, SUBJECT.getName(), VALUE.getName(), TYPENAME.getName(), CONTEXT.getName()));
        ValidationStepUtil.select(request.getDataEndpoint(), request.getValidation(), query, request.getLimit(), request.getOffset(), (TupleQueryResultHandler)resultHandler);
        return response;
    }
}

