/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class PropertyMinCardinalityValidationStep
implements ValidationStep,
DisplayableValidation,
OffendingValidationDataRetrieval {
    public static final String NAME = "propertyMinCardinality";
    private static final String SUBJECT = "subject";
    private static final String VALUE = "value";

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return propertyShape != null && !"id".equals(propertyShape.getName()) && (propertyShape.isRequired() || PropertyMinCardinalityValidationStep.isNonNullableSingleValue(propertyShape));
    }

    private static boolean isNonNullableSingleValue(PropertyShape propertyShape) {
        return propertyShape.isNonNullable() != false && !propertyShape.isMultivalued();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        Var subject = new Var(SUBJECT);
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, subject);
        com.ontotext.graphql.compiler.querymodel.Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        Var flag = new Var("flag");
        Var value = new Var("val");
        sparqlNodes.add(Exists.notExistsWithOptional((SparqlNode)PatternNode.createPattern((com.ontotext.graphql.compiler.querymodel.Value)subject, (com.ontotext.graphql.compiler.querymodel.Value)propertyPredicate, (com.ontotext.graphql.compiler.querymodel.Value)value), (Var)flag));
        String question = ValidationStepUtil.createAskQuery(schema, sparqlNodes);
        if (ValidationStepUtil.ask(dataEndpoint, validation, question).isYes()) {
            PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
            Object definition = "";
            if (property.isRequired()) {
                definition = "min: 1";
            }
            if (Boolean.TRUE.equals(property.isNonNullable())) {
                if (!((String)definition).isEmpty()) {
                    definition = (String)definition + ", ";
                }
                definition = (String)definition + "nonNullable: true";
            }
            validation.addResultMessage("validations.min-cardinality", validation.getObjectType(), validation.getPropertyName(), definition);
            validation.setTaskStatus(Task.TaskStatus.WARN);
        }
    }

    @Override
    public String getViewQuery(SomlSchema schema, ValidationTask validation) {
        SelectQuery query = this.buildViewQuery(schema, validation);
        query.setLimit(Long.valueOf(100L));
        return SparqlUtil.prettyPrint((String)query.toSparql());
    }

    @Override
    public DataRetrievalResponse loadData(DataRetrievalRequest request) {
        ValidationTask validation = request.getValidation();
        SomlSchema schema = request.getSchema();
        SelectQuery query = this.buildViewQuery(schema, validation);
        DataRetrievalResponse response = new DataRetrievalResponse();
        ConsumingTupleQueryResultHandler resultHandler = new ConsumingTupleQueryResultHandler(this.readBinding(response));
        ValidationStepUtil.select(request.getDataEndpoint(), request.getValidation(), query, request.getLimit(), request.getOffset(), (TupleQueryResultHandler)resultHandler);
        return response;
    }

    @NotNull
    private SelectQuery buildViewQuery(SomlSchema schema, ValidationTask validation) {
        Var subject = new Var(SUBJECT);
        Var value = new Var(VALUE);
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, subject);
        com.ontotext.graphql.compiler.querymodel.Value propertyPredicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        Var flag = new Var("flag");
        sparqlNodes.add(Exists.notExistsWithOptional((SparqlNode)PatternNode.createPattern((com.ontotext.graphql.compiler.querymodel.Value)subject, (com.ontotext.graphql.compiler.querymodel.Value)propertyPredicate, (com.ontotext.graphql.compiler.querymodel.Value)value), (Var)flag));
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, sparqlNodes);
        query.getProjectionSegment().add(subject);
        return query;
    }

    private Consumer<BindingSet> readBinding(DataRetrievalResponse response) {
        return bindingSet -> response.addResultEntry(Rdf4jValueConverter.convertAsString((Value)bindingSet.getValue(SUBJECT)));
    }
}

