/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Exists;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.PatternNode;
import com.ontotext.graphql.compiler.querymodel.SelectQuery;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.UnionCollection;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.compiler.querymodel.functions.DataType;
import com.ontotext.graphql.compiler.querymodel.functions.IsBlank;
import com.ontotext.graphql.compiler.querymodel.functions.IsIri;
import com.ontotext.graphql.compiler.querymodel.functions.IsLiteral;
import com.ontotext.models.Constraint;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.sparql.ConsumingTupleQueryResultHandler;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;

public class ObjectPropertyRangeMismatchValidatorStep
implements ValidationStep,
DisplayableValidation,
OffendingValidationDataRetrieval {
    public static final String NAME = "objectPropertyRangeMismatch";
    private static final Var VALUE = new Var("value");
    private static final Var TYPENAME = new Var("type");
    private static final Var SUBJECT = new Var("subject");
    private static final Var CONTEXT = new Var("context");

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return propertyShape != null && !"id".equals(propertyShape.getName()) && propertyShape.isObjectType();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        Map<String, Long> distributionCount;
        List<SparqlNode> sparqlNodes = this.buildMainSelection(schema, validation);
        PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
        List<SparqlNode> valueConstraints = ValidationStepUtil.getTypeConstraints(schema, property.getRange(), VALUE, null);
        sparqlNodes.add((SparqlNode)new Filter(Exists.notExists((SparqlNode)new SparqlNodeSequence(valueConstraints))));
        String question = ValidationStepUtil.createAskQuery(schema, sparqlNodes);
        if (ValidationStepUtil.ask(dataEndpoint, validation, question).isYes() && ValidationStepUtil.addRangeMismatchMessage(distributionCount = this.countOtherTypes(schema, validation, dataEndpoint), validation, property)) {
            validation.setTaskStatus(Task.TaskStatus.WARN);
        }
    }

    @Override
    public String getViewQuery(SomlSchema schema, ValidationTask validation) {
        SelectQuery query = this.buildViewQuery(schema, validation, false);
        query.setLimit(Long.valueOf(100L));
        return SparqlUtil.prettyPrint((String)query.toSparql());
    }

    @NotNull
    protected SelectQuery buildViewQuery(SomlSchema schema, ValidationTask validation, boolean lateral) {
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, SUBJECT);
        PatternNode propertyMatch = PatternNode.createPattern((Value)SUBJECT, (Value)ValidationStepUtil.getTargetPropertyPredicate(schema, validation), (Value)VALUE);
        if (lateral) {
            ArrayList<SparqlNode> subqueryNodes = new ArrayList<SparqlNode>();
            subqueryNodes.add((SparqlNode)propertyMatch);
            subqueryNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)CONTEXT).addNode((SparqlNode)propertyMatch)));
            subqueryNodes.add((SparqlNode)this.buildMainCheck(schema, ValidationStepUtil.getTargetProperty(schema, validation)));
            SelectQuery query = ValidationStepUtil.createSelectQuery(schema, subqueryNodes);
            query.convertToSubSelect();
            query.getProjectionSegment().add(SUBJECT);
            query.getProjectionSegment().add(VALUE);
            query.getProjectionSegment().add(CONTEXT);
            query.getProjectionSegment().add(TYPENAME);
            query.setValues(new Values(SUBJECT));
            sparqlNodes.add((SparqlNode)query);
        } else {
            sparqlNodes.add((SparqlNode)propertyMatch);
            sparqlNodes.add((SparqlNode)new Optional((SparqlNode)new NamedGraphTriplePatternBlock((Value)CONTEXT).addNode((SparqlNode)propertyMatch)));
            sparqlNodes.add((SparqlNode)this.buildMainCheck(schema, ValidationStepUtil.getTargetProperty(schema, validation)));
        }
        SelectQuery query = ValidationStepUtil.createSelectQuery(schema, sparqlNodes);
        query.getProjectionSegment().add(SUBJECT);
        query.getProjectionSegment().add(VALUE);
        query.getProjectionSegment().add(CONTEXT);
        query.getProjectionSegment().add(TYPENAME);
        return query;
    }

    @NotNull
    private List<SparqlNode> buildMainSelection(SomlSchema schema, ValidationTask validation) {
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, SUBJECT);
        PatternNode propertyMatch = PatternNode.createPattern((Value)SUBJECT, (Value)ValidationStepUtil.getTargetPropertyPredicate(schema, validation), (Value)VALUE);
        sparqlNodes.add((SparqlNode)propertyMatch);
        return sparqlNodes;
    }

    @NotNull
    private Map<String, Long> countOtherTypes(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        List<SparqlNode> sparqlNodes = this.buildMainSelection(schema, validation);
        PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
        UnionCollection unionCollection = this.buildMainCheck(schema, property);
        sparqlNodes.add((SparqlNode)unionCollection);
        return ValidationStepUtil.executeCountAggregationQuery(schema, sparqlNodes, TYPENAME, dataEndpoint, validation);
    }

    @NotNull
    private UnionCollection buildMainCheck(SomlSchema schema, PropertyShape property) {
        UnionCollection unionCollection = new UnionCollection();
        unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsIri((SparqlNode)VALUE)), this.getNoneOfTheKnownTypeConstraints(schema), new Bind((SparqlNode)Literal.asString((String)"iri"), (Value)TYPENAME)}));
        unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsLiteral((SparqlNode)VALUE)), new Bind((SparqlNode)new DataType((SparqlNode)VALUE), (Value)TYPENAME)}));
        unionCollection.addNode((SparqlNode)new TriplePatternBlock(new SparqlNode[]{new Filter((SparqlNode)new IsBlank((SparqlNode)VALUE)), new Bind((SparqlNode)Literal.asString((String)"blank"), (Value)TYPENAME)}));
        List<SparqlNode> allOtherTypeConstraints = ValidationStepUtil.getAllOtherTypeConstraints(schema, property.getRange(), VALUE, TYPENAME);
        if (!allOtherTypeConstraints.isEmpty()) {
            unionCollection.addNode((SparqlNode)new TriplePatternBlock(allOtherTypeConstraints));
        }
        return unionCollection;
    }

    private SparqlNode getNoneOfTheKnownTypeConstraints(SomlSchema schema) {
        Shapes userDefinedShapes = schema.getObjects().getUserDefinedShapes();
        userDefinedShapes.remove((Object)"Object");
        userDefinedShapes.remove((Object)"Nameable");
        Set constraints = userDefinedShapes.values().stream().filter(shape -> !shape.isAbstract() && !shape.isUnion()).map(Shape::getId).map(Constraint::new).collect(Collectors.toSet());
        ArrayList sparqlNodes = new ArrayList();
        new ConstraintGenerator(schema, OperationBuilderOptions.DEFAULT).addBoTypeConstraint(constraints, sparqlNodes, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(VALUE).boTypeAlias("otherType").build());
        return new Filter(Exists.notExists((SparqlNode)new TriplePatternBlock(sparqlNodes)));
    }

    @Override
    public DataRetrievalResponse loadData(DataRetrievalRequest request) {
        DataRetrievalResponse response = new DataRetrievalResponse();
        ConsumingTupleQueryResultHandler resultHandler = new ConsumingTupleQueryResultHandler(ValidationStepUtil.readBindings(response::addResultEntry, SUBJECT.getName(), VALUE.getName(), TYPENAME.getName(), CONTEXT.getName()));
        ValidationStepUtil.select(request.getDataEndpoint(), request.getValidation(), this.buildViewQuery(request.getSchema(), request.getValidation(), true), request.getLimit(), request.getOffset(), (TupleQueryResultHandler)resultHandler);
        return response;
    }
}

