/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data.steps;

import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.steps.ValidationStepUtil;
import java.util.List;

public class MaxCardinalityAdviceValidationStep
implements ValidationStep {
    public static final String NAME = "maxCardinalityAdvice";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(SomlSchema schema, Shape shape, PropertyShape propertyShape) {
        return propertyShape != null && !"type".equals(propertyShape.getName()) && propertyShape.isMultivalued();
    }

    @Override
    public void validate(SomlSchema schema, ValidationTask validation, DataEndpoint dataEndpoint) {
        Var subject = new Var("subject");
        List<SparqlNode> sparqlNodes = ValidationStepUtil.getTypeConstraints(schema, validation, subject);
        Value predicate = ValidationStepUtil.getTargetPropertyPredicate(schema, validation);
        sparqlNodes.addAll(ValidationStepUtil.createIsMultiValueCheck((Value)subject, predicate, new Var("value")));
        String question = ValidationStepUtil.createAskQuery(schema, sparqlNodes);
        if (ValidationStepUtil.ask(dataEndpoint, validation, question).isNo()) {
            PropertyShape property = ValidationStepUtil.getTargetProperty(schema, validation);
            validation.addResultMessage("validations.max-cardinality-advice", validation.getObjectType(), validation.getPropertyName(), property.getMax());
            validation.setTaskStatus(Task.TaskStatus.INFO);
        }
    }
}

