/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.ResourceNotFoundException;
import com.ontotext.validator.data.DisplayableValidation;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationSteps;
import com.ontotext.validator.data.ValidationTask;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.apache.http.client.utils.URIBuilder;

public class ValidationViewQueryGenerator {
    private final ValidationManager validationManager;
    private final Function<String, SomlSchema> schemaLoader;
    private final String publicDatabaseAddress;

    public ValidationViewQueryGenerator(ValidationManager validationManager, Function<String, SomlSchema> schemaLoader, String publicDatabaseAddress) {
        this.validationManager = validationManager;
        this.schemaLoader = schemaLoader;
        this.publicDatabaseAddress = publicDatabaseAddress;
    }

    public Optional<URI> generateQueryRequest(String schemaId, String taskId) {
        if (this.publicDatabaseAddress == null) {
            return Optional.empty();
        }
        ValidationTask validationTask = this.validationManager.getValidationTask(schemaId, taskId).orElseThrow(() -> this.noActiveValidation(schemaId));
        ValidationStep step = ValidationSteps.getStep(validationTask.getValidatorName());
        if (!(step instanceof DisplayableValidation)) {
            return Optional.empty();
        }
        SomlSchema somlSchema = this.schemaLoader.apply(schemaId);
        String query = ((DisplayableValidation)((Object)step)).getViewQuery(somlSchema, validationTask);
        if (query != null) {
            try {
                return Optional.of(new URIBuilder(this.publicDatabaseAddress, StandardCharsets.UTF_8).setPath("/sparql").setParameter("name", this.generateName(validationTask)).setParameter("infer", "true").setParameter("sameAs", "true").setParameter("query", query).build());
            }
            catch (URISyntaxException use) {
                throw new PlatformConfigurationException(use.getMessage(), ErrorCode.UNHANDLED_RUNTIME);
            }
        }
        return Optional.empty();
    }

    private String generateName(ValidationTask task) {
        return task.getObjectType() + " " + task.getPropertyName() + " (" + task.getTaskOrder() + ")";
    }

    private RuntimeException noActiveValidation(String schemaId) {
        return new ResourceNotFoundException("No active validation for " + schemaId, ErrorCode.NO_SCHEMA_VALIDATION);
    }
}

