/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.tasks.BaseTaskService;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.TaskProcessorFactory;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.tasks.job.JobNotifiable;
import com.ontotext.tasks.processing.JobContext;
import com.ontotext.tasks.processing.TaskDispatcher;
import com.ontotext.tasks.processing.TaskProviderCallback;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.processing.ValidationTaskDispatcher;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ValidationService
extends BaseTaskService<ValidationTask>
implements JobListener {
    private final ValidationManager validationManager;

    public ValidationService(ValidationManager validationManager, TaskProcessorFactory taskProcessorFactory, Function<String, JobContext> schemaLoader) {
        super((JobNotifiable)validationManager, taskProcessorFactory, schemaLoader);
        this.validationManager = validationManager;
    }

    protected TaskDispatcher<ValidationTask, DataEndpoint> createNewDispatcher() {
        return new ValidationTaskDispatcher();
    }

    @NotNull
    protected TaskProviderCallback<ValidationTask> getTaskProviderCallback(final String schemaId) {
        return new TaskProviderCallback<ValidationTask>(){

            public List<ValidationTask> getNextTasks(int nextBatch) {
                return ValidationService.this.validationManager.getNextTasks(schemaId, nextBatch);
            }

            public void updateTasks(List<ValidationTask> doneTasks) {
                ValidationService.this.validationManager.updateJob(schemaId, doneTasks);
            }
        };
    }
}

