/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.HealthCheckable;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.job.JobNotifiable;
import com.ontotext.validator.data.ValidationDataRetrievalService;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationTask;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface ValidationManager
extends HealthCheckable,
JobNotifiable {
    default public ValidationJob validate(SomlSchema schema, String repository) {
        return this.validate(schema, (Set<String>)null, null, null, repository);
    }

    default public ValidationJob validate(SomlSchema schema, Set<String> validations, String repository) {
        return this.validate(schema, (Set<String>)null, null, validations, repository);
    }

    default public ValidationJob validate(SomlSchema schema, Set<String> properties, Set<String> validations, String repository) {
        return this.validate(schema, (Set<String>)null, properties, validations, repository);
    }

    default public ValidationJob validate(SomlSchema schema, String type, Set<String> properties, Set<String> validations, String repository) {
        return this.validate(schema, Set.of(type), properties, validations, repository);
    }

    public ValidationJob validate(SomlSchema var1, Set<String> var2, Set<String> var3, Set<String> var4, String var5);

    public boolean removeValidation(String var1);

    public boolean removeValidationById(String var1);

    public Optional<ValidationJob> cancelValidation(String var1);

    public Optional<ValidationJob> cancelValidationById(String var1);

    default public Optional<ValidationJobReport> getValidationReport(String schemaId, boolean failedOnly, boolean fetchValues) {
        return this.getValidationReport(schemaId, failedOnly, fetchValues ? 1000L : 0L, 0L);
    }

    public Optional<ValidationJobReport> getValidationReport(String var1, boolean var2, long var3, long var5);

    default public Optional<ValidationJobReport> getValidationReportById(String jobId, boolean failedOnly, boolean fetchValues) {
        return this.getValidationReportById(jobId, failedOnly, fetchValues ? 1000L : 0L, 0L);
    }

    public Optional<ValidationJobReport> getValidationReportById(String var1, boolean var2, long var3, long var5);

    public Optional<ValidationJob> getValidation(String var1);

    public Optional<ValidationTask> getValidationTask(String var1, String var2);

    public void updateJob(String var1, List<ValidationTask> var2);

    public List<ValidationTask> getNextTasks(String var1, int var2);

    public boolean continueValidationJobs();

    public void setSchemaLoader(Function<String, SomlSchema> var1);

    public void shutdown();

    public boolean isJobDone(String var1);

    public void disableDataLoading();

    public boolean isDataLoadingEnabled();

    default public void loadOffendingValues(Collection<ValidationJobReport> reports, DataEndpointProvider endpointProvider, ValidationDataRetrievalService validationDataRetrievalService, Function<String, SomlSchema> schemaLoader, long limit, long offset) {
        if (!this.isDataLoadingEnabled()) {
            reports.stream().flatMap(report -> report.getTasks().stream()).filter(task -> task.getTaskStatus().hasResult() && task.isDataQueryable()).forEach(task -> task.addResultMessage("validations.dataLoading.disabled", new Object[0]));
            return;
        }
        for (ValidationJobReport report2 : reports) {
            DataEndpoint dataEndpoint = endpointProvider.getDataEndpoint(report2.getRepository());
            String schemaId = report2.getSchemaId();
            ValidationDataRetrievalService.DataRetrievalJob dataRetrievalJob = validationDataRetrievalService.newDataRetrievalJob(schemaLoader.apply(schemaId), dataEndpoint, limit, offset);
            for (ValidationTask task2 : report2.getTasks()) {
                if (!task2.getTaskStatus().hasResult() || !task2.isDataQueryable()) continue;
                dataRetrievalJob.queueDataFetching(task2);
            }
            dataRetrievalJob.waitForData();
        }
    }
}

