/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationTask;
import de.escalon.hypermedia.hydra.mapping.Expose;
import de.escalon.hypermedia.hydra.mapping.Term;
import de.escalon.hypermedia.hydra.mapping.Terms;
import de.escalon.hypermedia.hydra.mapping.Vocab;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Vocab(value="http://ontotext.com/ontology/validation/")
@Terms(value={@Term(define="@base", as="http://data.ontotext.com/"), @Term(define="xsd", as="http://www.w3.org/2001/XMLSchema#"), @Term(define="hydra", as="http://www.w3.org/ns/hydra/core#")})
@Expose(value="ValidationReport")
public class ValidationJobReport
extends ValidationJob {
    @JsonIgnore
    private List<ValidationTask> tasks = new LinkedList<ValidationTask>();

    public ValidationJobReport() {
    }

    public ValidationJobReport(String jobId) {
        super(jobId);
    }

    public ValidationJobReport(ValidationJob copyFrom) {
        super(copyFrom);
    }

    public ValidationJobReport(ValidationJobReport copyFrom) {
        super(copyFrom);
        this.tasks = copyFrom.getTasks().stream().map(ValidationTask::copy).collect(Collectors.toList());
    }

    public List<ValidationTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<ValidationTask> tasks) {
        this.tasks = tasks;
    }

    public void addTask(ValidationTask task) {
        this.tasks.add(task);
    }

    @JsonProperty(value="tasks")
    public List<Map<String, Object>> getTaskAsJson() {
        return this.getTasks().stream().map(ValidationTask::asJson).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return new StringBuilder(30).append("ValidationJobReport{").append(super.toString()).append("\ntasks=").append(this.tasks).append('}').toString();
    }
}

