/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.models.SomlSchema;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.tasks.DataEndpoint;
import com.ontotext.validator.data.DataRetrievalRequest;
import com.ontotext.validator.data.DataRetrievalResponse;
import com.ontotext.validator.data.OffendingValidationDataRetrieval;
import com.ontotext.validator.data.ValidationStep;
import com.ontotext.validator.data.ValidationSteps;
import com.ontotext.validator.data.ValidationTask;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationDataRetrievalService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ExecutorService executorService = new ThreadPoolExecutor(5, 25, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("data-fetcher-%d").setPriority(3).build());

    public DataRetrievalJob newDataRetrievalJob(SomlSchema schema, DataEndpoint dataEndpoint, long limit, long offset) {
        return new DataRetrievalJob(this.executorService, dataEndpoint, schema, limit, offset);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }

    public static class DataRetrievalJob {
        private final ExecutorService executorService;
        private final DataEndpoint dataEndpoint;
        private int totalTaskCount = 0;
        private AtomicInteger doneTasks = new AtomicInteger();
        private final SomlSchema schema;
        private final long limit;
        private final long offset;

        DataRetrievalJob(ExecutorService executorService, DataEndpoint dataEndpoint, SomlSchema schema, long limit, long offset) {
            this.executorService = executorService;
            this.dataEndpoint = dataEndpoint;
            this.schema = schema;
            this.limit = limit;
            this.offset = offset;
        }

        public void queueDataFetching(ValidationTask task) {
            this.executorService.submit(SparqlEndpointRequestContext.decorateTask((Runnable)this.fetchData(task)));
            ++this.totalTaskCount;
        }

        private Runnable fetchData(ValidationTask task) {
            return () -> {
                try {
                    String validatorName = task.getValidatorName();
                    ValidationStep step = ValidationSteps.getStep(validatorName);
                    DataRetrievalRequest request = new DataRetrievalRequest();
                    request.setDataEndpoint(this.dataEndpoint);
                    request.setValidation(task);
                    request.setSchema(this.schema);
                    request.setLimit(this.limit);
                    request.setOffset(this.offset);
                    try {
                        DataRetrievalResponse response = ((OffendingValidationDataRetrieval)((Object)step)).loadData(request);
                        task.setViolations(response.getValues());
                    }
                    catch (RuntimeException re) {
                        LOGGER.warn("Data fetching failed", (Throwable)re);
                        task.addResult("Data fetching failure: " + re.getMessage());
                    }
                }
                finally {
                    this.doneTasks.incrementAndGet();
                }
            };
        }

        public void waitForData() {
            if (this.totalTaskCount == 0) {
                return;
            }
            if (this.doneTasks.get() != this.totalTaskCount) {
                LOGGER.info("Waiting for data retrieval. {} out of {} tasks done", (Object)this.doneTasks.get(), (Object)this.totalTaskCount);
            }
            long start = System.currentTimeMillis();
            while (this.doneTasks.get() != this.totalTaskCount) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    LOGGER.warn("Data retrieval interrupted");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            LOGGER.info("Data retrieval completed. Waited {} s", (Object)((System.currentTimeMillis() - start) / 1000L));
        }
    }
}

