/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.job.JobEventNotifier;
import com.ontotext.tasks.job.JobEventType;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.validator.data.SomlSchemaValidationTaskGenerator;
import com.ontotext.validator.data.ValidationDataRetrievalService;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class InMemoryValidationManager
implements ValidationManager {
    private final DataEndpointProvider dataEndpointProvider;
    private JobEventNotifier eventNotifier = new JobEventNotifier();
    private SomlSchemaValidationTaskGenerator taskGenerator = new SomlSchemaValidationTaskGenerator();
    private ValidationDataRetrievalService dataRetrievalService = new ValidationDataRetrievalService();
    private Set<ValidationState> jobs = ConcurrentHashMap.newKeySet();
    private Function<String, SomlSchema> schemaLoader;
    private boolean disableDataLoading = false;

    public InMemoryValidationManager(DataEndpointProvider dataEndpointProvider) {
        this.dataEndpointProvider = dataEndpointProvider;
    }

    @Override
    public ValidationJob validate(SomlSchema schema, Set<String> types, Set<String> properties, Set<String> validations, String repository) {
        this.removeValidation(schema.getId());
        List<ValidationTask> validationTasks = types == null || types.stream().allMatch(StringUtils::isEmpty) ? this.taskGenerator.prepareForValidation(schema, properties) : this.taskGenerator.prepareForValidation(schema, types, properties);
        if (validations != null && !validations.isEmpty()) {
            validationTasks.removeIf(task -> !validations.contains(task.getName()));
        }
        ValidationJobReport job = new ValidationJobReport();
        job.setJobId(UUID.randomUUID().toString());
        job.setRemainingTasks(validationTasks.size());
        job.setTotalTasks(validationTasks.size());
        job.setSchemaId(schema.getId());
        job.setTasks(validationTasks);
        job.setCreatedOn(new Date());
        job.setRepository(repository);
        this.initTaskData(validationTasks);
        ValidationState state = new ValidationState(new ValidationJob(job), validationTasks);
        this.jobs.add(state);
        if (validationTasks.isEmpty()) {
            this.notifyListeners(job.getJobId(), schema.getId(), repository, JobEventType.JOB_CANCELED);
        } else {
            this.notifyListeners(job.getJobId(), schema.getId(), repository, JobEventType.NEW_JOB);
        }
        return job;
    }

    private void initTaskData(List<ValidationTask> validationTasks) {
        int count = 1;
        for (ValidationTask task : validationTasks) {
            if (task.getId() == null) {
                task.setId(UUID.randomUUID().toString());
            }
            task.setTaskOrder(count++);
            if (task.getTaskStatus() != null) continue;
            task.setTaskStatus(Task.TaskStatus.NOT_RUN);
        }
    }

    @Override
    public boolean removeValidation(String schemaId) {
        return this.jobs.removeIf(entry -> {
            if (entry.job.getSchemaId().equals(schemaId)) {
                this.notifyListeners(entry.job.getJobId(), schemaId, entry.job.getRepository(), JobEventType.JOB_REMOVED);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean removeValidationById(String jobId) {
        return this.jobs.removeIf(entry -> {
            if (entry.job.getJobId().equals(jobId)) {
                this.notifyListeners(entry.job.getJobId(), entry.job.getSchemaId(), entry.job.getRepository(), JobEventType.JOB_REMOVED);
                return true;
            }
            return false;
        });
    }

    @Override
    public synchronized Optional<ValidationJob> cancelValidation(String schemaId) {
        ArrayList cancelledJobs = new ArrayList();
        this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).forEach(jobReport -> {
            if (jobReport.job.isActive()) {
                jobReport.job.setCanceledOn(new Date());
                this.notifyListeners(jobReport.job.getJobId(), jobReport.job.getSchemaId(), jobReport.job.getRepository(), JobEventType.JOB_CANCELED);
                cancelledJobs.add(jobReport.job);
            }
        });
        if (cancelledJobs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ValidationJob)cancelledJobs.get(0));
    }

    @Override
    public Optional<ValidationJob> cancelValidationById(String jobId) {
        ArrayList cancelledJobs = new ArrayList();
        this.jobs.stream().filter(entry -> entry.job.getJobId().equals(jobId)).forEach(jobReport -> {
            if (jobReport.job.isActive()) {
                jobReport.job.setCanceledOn(new Date());
                this.notifyListeners(jobReport.job.getJobId(), jobReport.job.getSchemaId(), jobReport.job.getRepository(), JobEventType.JOB_CANCELED);
                cancelledJobs.add(jobReport.job);
            }
        });
        if (cancelledJobs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ValidationJob)cancelledJobs.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ValidationJobReport> getValidationReport(String schemaId, boolean failedOnly, long limit, long offset) {
        Optional<ValidationJobReport> report;
        InMemoryValidationManager inMemoryValidationManager = this;
        synchronized (inMemoryValidationManager) {
            report = this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).map(validationState -> validationState.toJobReport(failedOnly)).findFirst();
        }
        report.ifPresent(jobReport -> {
            if (limit > 0L) {
                this.loadOffendingValues(List.of(jobReport), this.dataEndpointProvider, this.dataRetrievalService, this.schemaLoader, limit, offset);
            }
        });
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ValidationJobReport> getValidationReportById(String jobId, boolean failedOnly, long limit, long offset) {
        Optional<ValidationJobReport> report;
        InMemoryValidationManager inMemoryValidationManager = this;
        synchronized (inMemoryValidationManager) {
            report = this.jobs.stream().filter(entry -> entry.job.getJobId().equals(jobId)).map(validationState -> validationState.toJobReport(failedOnly)).findFirst();
        }
        if (limit > 0L) {
            report.ifPresent(jobReport -> this.loadOffendingValues(List.of(jobReport), this.dataEndpointProvider, this.dataRetrievalService, this.schemaLoader, limit, offset));
        }
        return report;
    }

    @Override
    public Optional<ValidationJob> getValidation(String schemaId) {
        return this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).map(ValidationState::toJob).findFirst();
    }

    @Override
    public synchronized Optional<ValidationTask> getValidationTask(String schemaId, String taskId) {
        return this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).map(validationState -> validationState.tasks.get(taskId)).filter(Objects::nonNull).findFirst();
    }

    @Override
    public synchronized void updateJob(String schemaId, List<ValidationTask> toUpdate) {
        this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).findFirst().ifPresent(validationState -> validationState.updateTasks(toUpdate));
    }

    @Override
    public synchronized List<ValidationTask> getNextTasks(String schemaId, int numberOfTasks) {
        ValidationState validationState = this.jobs.stream().filter(entry -> entry.job.getSchemaId().equals(schemaId)).findFirst().orElse(null);
        if (validationState == null || validationState.job.getCanceledOn() != null) {
            return Collections.emptyList();
        }
        List<ValidationTask> tasks = validationState.getNextTasks(numberOfTasks);
        if (tasks.isEmpty()) {
            validationState.job.setCompletedOn(new Date());
            this.notifyListeners(validationState.job.getJobId(), schemaId, validationState.job.getRepository(), JobEventType.JOB_COMPLETED);
        }
        return tasks;
    }

    public void removeJobListener(JobListener jobEventConsumer) {
        this.eventNotifier.removeJobListener(jobEventConsumer);
    }

    public void addJobListener(JobListener jobEventConsumer) {
        this.eventNotifier.addJobListener(jobEventConsumer);
    }

    @Override
    public boolean continueValidationJobs() {
        return false;
    }

    @Override
    public void setSchemaLoader(Function<String, SomlSchema> schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    @Override
    public void shutdown() {
        this.dataRetrievalService.close();
    }

    @Override
    public boolean isJobDone(String jobId) {
        Optional<ValidationJobReport> report = this.getValidationReportById(jobId, false, false);
        if (report.isEmpty()) {
            return true;
        }
        return report.filter(ValidationJob::isDone).isPresent();
    }

    @Override
    public void disableDataLoading() {
        this.disableDataLoading = true;
    }

    @Override
    public boolean isDataLoadingEnabled() {
        return !this.disableDataLoading;
    }

    private void notifyListeners(String jobId, String schemaId, String repository, JobEventType eventType) {
        this.eventNotifier.notifyListeners(jobId, schemaId, repository, eventType);
    }

    public HealthResult runHealthCheck() {
        return HealthResult.green((String)"in-memory-validation-manager");
    }

    private static class ValidationState {
        private final ValidationJob job;
        private Map<String, ValidationTask> tasks;

        private ValidationState(ValidationJob job, List<ValidationTask> validationTasks) {
            this.job = job;
            this.tasks = validationTasks.stream().collect(Collectors.toMap(ValidationTask::getId, Function.identity(), (task, task2) -> task, LinkedHashMap::new));
        }

        ValidationJob toJob() {
            ValidationJob report = new ValidationJob(this.job);
            this.computeTaskCounts(report);
            return report;
        }

        ValidationJobReport toJobReport(boolean failedTasksOnly) {
            ValidationJobReport report = new ValidationJobReport(this.job);
            report.setTasks(this.tasks.values().stream().filter(this.filterTasks(failedTasksOnly)).map(ValidationTask::copy).sorted(this.byTaskOrder()).collect(Collectors.toList()));
            this.computeTaskCounts(report);
            return report;
        }

        private void computeTaskCounts(ValidationJob report) {
            this.tasks.values().forEach(task -> this.updateJobCounts(report, (ValidationTask)task));
            report.setRemainingTasks(this.computeRemainingTasks());
        }

        private int computeRemainingTasks() {
            return (int)this.tasks.values().stream().filter(task -> !task.getTaskStatus().isDone()).count();
        }

        private Comparator<ValidationTask> byTaskOrder() {
            return Comparator.comparing(ValidationTask::getTaskOrder);
        }

        private Predicate<ValidationTask> filterTasks(boolean failedOnly) {
            if (failedOnly) {
                return task -> task.getTaskStatus().hasResult();
            }
            return task -> true;
        }

        private void updateJobCounts(ValidationJob job, ValidationTask validationTask) {
            if (validationTask.getTaskStatus() == Task.TaskStatus.WARN) {
                job.setWarningTasks(job.getWarningTasks() + 1);
            } else if (validationTask.getTaskStatus() == Task.TaskStatus.FAIL) {
                job.setFailedTasks(job.getFailedTasks() + 1);
            } else if (validationTask.getTaskStatus() == Task.TaskStatus.INFO) {
                job.setInfoTasks(job.getInfoTasks() + 1);
            }
        }

        private void updateTasks(List<ValidationTask> toUpdate) {
            for (ValidationTask task : toUpdate) {
                this.tasks.put(task.getId(), task.copy());
            }
        }

        private List<ValidationTask> getNextTasks(int numberOfTasks) {
            return this.tasks.values().stream().filter(task -> task.getTaskStatus() == Task.TaskStatus.NOT_RUN).limit(numberOfTasks).peek(task -> task.setTaskStatus(Task.TaskStatus.RUNNING)).map(ValidationTask::copy).collect(Collectors.toList());
        }
    }
}

