/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.BadRequestException;
import com.ontotext.soaas.common.exceptions.ResourceNotFoundException;
import com.ontotext.tasks.job.JobEventType;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationManager;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateValidation {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ValidationManager inMemoryValidationManager;
    private final AtomicReference<String> futureJobId = new AtomicReference();
    private final Set<String> completedJobIds = ConcurrentHashMap.newKeySet();
    private final CountDownLatch jobBlock = new CountDownLatch(1);
    private final JobListener endOfJobListener = jobEvent -> {
        JobEventType eventType = jobEvent.getEventType();
        if (eventType != JobEventType.NEW_JOB && eventType != JobEventType.JOB_RESUMED) {
            this.completedJobIds.add(jobEvent.getJobId());
            String acquired = this.futureJobId.getAcquire();
            if (acquired != null && acquired.equals(jobEvent.getJobId())) {
                this.jobBlock.countDown();
            }
        }
    };

    public ImmediateValidation(ValidationManager inMemoryValidationManager) {
        this.inMemoryValidationManager = inMemoryValidationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationJob validateBlocking(SomlSchema schema, Set<String> types, Set<String> properties, Set<String> validations, boolean failedOnly, long limit, long offset, String repository, long timeoutInMillis) {
        this.inMemoryValidationManager.addJobListener(this.endOfJobListener);
        ValidationJob validationJob = this.inMemoryValidationManager.validate(schema, types, properties, validations, repository);
        this.futureJobId.setRelease(validationJob.getJobId());
        try {
            this.waitForJobCompletion(timeoutInMillis, validationJob);
            ValidationJob validationJob2 = this.inMemoryValidationManager.getValidationReportById(validationJob.getJobId(), failedOnly, limit, offset).orElseThrow(() -> ResourceNotFoundException.somlNotFound((String)schema.getId()));
            return validationJob2;
        }
        finally {
            this.inMemoryValidationManager.removeJobListener(this.endOfJobListener);
            this.inMemoryValidationManager.removeValidationById(validationJob.getJobId());
        }
    }

    private void waitForJobCompletion(long timeoutInMillis, ValidationJob validationJob) {
        long initialTime = System.currentTimeMillis();
        if (!this.completedJobIds.contains(validationJob.getJobId()) && this.jobBlock.getCount() != 0L) {
            try {
                if (timeoutInMillis == 0L) {
                    this.jobBlock.await();
                } else if (!this.jobBlock.await(timeoutInMillis, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Validation didn't finish in time. Cancelling the remaining tasks.");
                    this.inMemoryValidationManager.cancelValidationById(validationJob.getJobId());
                    return;
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new BadRequestException("Validation could not finish in time", ErrorCode.UNHANDLED_RUNTIME);
            }
        }
        while (!this.inMemoryValidationManager.isJobDone(validationJob.getJobId())) {
            if (timeoutInMillis > 0L && System.currentTimeMillis() - initialTime > timeoutInMillis) {
                LOGGER.warn("Timeout while waiting for the last tasks");
                break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new BadRequestException("Validation could not finish in time", ErrorCode.UNHANDLED_RUNTIME);
            }
        }
    }
}

