/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import com.ontotext.graphdb.server.GraphDBAppConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.rdf4j.common.app.AppConfiguration;
import org.eclipse.rdf4j.console.Command;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.ConsoleStateForCreate;
import org.eclipse.rdf4j.console.GraphDBConnect;
import org.eclipse.rdf4j.console.GraphDBCreate;
import org.eclipse.rdf4j.console.Help;
import org.eclipse.rdf4j.console.command.Clear;
import org.eclipse.rdf4j.console.command.Close;
import org.eclipse.rdf4j.console.command.Connect;
import org.eclipse.rdf4j.console.command.Disconnect;
import org.eclipse.rdf4j.console.command.Drop;
import org.eclipse.rdf4j.console.command.Export;
import org.eclipse.rdf4j.console.command.Federate;
import org.eclipse.rdf4j.console.command.Load;
import org.eclipse.rdf4j.console.command.Open;
import org.eclipse.rdf4j.console.command.PrintHelp;
import org.eclipse.rdf4j.console.command.PrintInfo;
import org.eclipse.rdf4j.console.command.QueryEvaluator;
import org.eclipse.rdf4j.console.command.SetParameters;
import org.eclipse.rdf4j.console.command.Show;
import org.eclipse.rdf4j.console.command.Sparql;
import org.eclipse.rdf4j.console.command.TupleAndGraphQueryEvaluator;
import org.eclipse.rdf4j.console.command.Verify;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.ConsoleWidth;
import org.eclipse.rdf4j.console.setting.LogLevel;
import org.eclipse.rdf4j.console.setting.Prefixes;
import org.eclipse.rdf4j.console.setting.QueryPrefix;
import org.eclipse.rdf4j.console.setting.ShowPrefix;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class GraphDBConsole
implements ConsoleState {
    private static boolean exitOnError;
    private final AppConfiguration appConfig = new GraphDBAppConfiguration();
    private RepositoryManager manager;
    private String managerID;
    private Repository repository;
    private String repositoryID;
    private final ConsoleIO consoleIO;
    private int consoleWidth = 80;
    private boolean showPrefix = true;
    private boolean queryPrefix = false;
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final Map<String, ConsoleSetting> settingsMap = new HashMap<String, ConsoleSetting>();
    private Map<String, Help> helpMap = new TreeMap<String, Help>();
    private final Connect connect;
    private final Disconnect disconnect;
    private final Open open;
    private final TupleAndGraphQueryEvaluator baseEval;
    private final QueryEvaluator queryEvaluator;
    private final Export export;

    public static void main(String[] args) throws IOException {
        GraphDBConsole console = new GraphDBConsole();
        Option helpOption = new Option("h", "help", false, "print this help");
        Option versionOption = new Option("v", "version", false, "print version information");
        Option serverURLOption = new Option("s", "serverURL", true, "URL of Sesame server to connect to, e.g. http://localhost/openrdf-sesame/");
        Option dirOption = new Option("d", "dataDir", true, "Sesame data dir to 'connect' to");
        Option echoOption = new Option("e", "echo", false, "echoes input back to stdout, useful for logging script sessions");
        Option quietOption = new Option("q", "quiet", false, "suppresses prompts, useful for scripting");
        Option forceOption = new Option("f", "force", false, "always answer yes to (suppressed) confirmation prompts");
        Option cautiousOption = new Option("c", "cautious", false, "always answer no to (suppressed) confirmation prompts");
        Option exitOnErrorMode = new Option("x", "exitOnError", false, "immediately exit the console on the first error");
        Options options = new Options();
        OptionGroup cautionGroup = new OptionGroup().addOption(cautiousOption).addOption(forceOption).addOption(exitOnErrorMode);
        OptionGroup locationGroup = new OptionGroup().addOption(serverURLOption).addOption(dirOption);
        options.addOptionGroup(locationGroup).addOptionGroup(cautionGroup);
        options.addOption(helpOption).addOption(versionOption).addOption(echoOption).addOption(quietOption);
        CommandLine commandLine = GraphDBConsole.parseCommandLine(args, console, options);
        GraphDBConsole.handleInfoOptions(console, helpOption, versionOption, options, commandLine);
        console.consoleIO.setEcho(commandLine.hasOption(echoOption.getOpt()));
        console.consoleIO.setQuiet(commandLine.hasOption(quietOption.getOpt()));
        exitOnError = commandLine.hasOption(exitOnErrorMode.getOpt());
        String location = GraphDBConsole.handleOptionGroups(console, serverURLOption, dirOption, forceOption, cautiousOption, options, cautionGroup, locationGroup, commandLine);
        String[] otherArgs = commandLine.getArgs();
        if (otherArgs.length > 1) {
            GraphDBConsole.printUsage(console.consoleIO, options);
            System.exit(1);
        }
        GraphDBConsole.connectAndOpen(console, locationGroup.getSelected(), location, otherArgs);
        console.start();
    }

    private static String handleOptionGroups(GraphDBConsole console, Option serverURLOption, Option dirOption, Option forceOption, Option cautiousOption, Options options, OptionGroup cautionGroup, OptionGroup locationGroup, CommandLine commandLine) {
        String location = null;
        try {
            if (commandLine.hasOption(forceOption.getOpt())) {
                cautionGroup.setSelected(forceOption);
                console.consoleIO.setForce();
            }
            if (commandLine.hasOption(cautiousOption.getOpt())) {
                cautionGroup.setSelected(cautiousOption);
                console.consoleIO.setCautious();
            }
            if (commandLine.hasOption(dirOption.getOpt())) {
                locationGroup.setSelected(dirOption);
                location = commandLine.getOptionValue(dirOption.getOpt());
            }
            if (commandLine.hasOption(serverURLOption.getOpt())) {
                locationGroup.setSelected(serverURLOption);
                location = commandLine.getOptionValue(serverURLOption.getOpt());
            }
        }
        catch (AlreadySelectedException e) {
            GraphDBConsole.printUsage(console.consoleIO, options);
            System.exit(3);
        }
        return location;
    }

    private static CommandLine parseCommandLine(String[] args, GraphDBConsole console, Options options) {
        CommandLine commandLine = null;
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            console.consoleIO.writeError(e.getMessage());
            System.exit(1);
        }
        return commandLine;
    }

    private static void handleInfoOptions(GraphDBConsole console, Option helpOption, Option versionOption, Options options, CommandLine commandLine) {
        if (commandLine.hasOption(helpOption.getOpt())) {
            GraphDBConsole.printUsage(console.consoleIO, options);
            System.exit(0);
        }
        if (commandLine.hasOption(versionOption.getOpt())) {
            console.consoleIO.writeln(console.appConfig.getFullName());
            System.exit(0);
        }
    }

    private static void connectAndOpen(GraphDBConsole console, String selectedLocationOption, String location, String[] otherArgs) {
        boolean connected = "s".equals(selectedLocationOption) ? console.connect.connectRemote(location) : ("d".equals(selectedLocationOption) ? console.connect.connectLocal(location) : console.connect.connectDefault());
        if (!connected) {
            System.exit(2);
        }
        if (otherArgs.length > 0) {
            console.open.openRepository(otherArgs[0]);
        }
    }

    private static void printUsage(ConsoleIO cio, Options options) {
        cio.writeln("Sesame Console, an interactive shell based utility to communicate with Sesame repositories.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.printHelp("start-console [OPTION] [repositoryID]", options);
        cio.writeln();
        cio.writeln("For bug reports and suggestions, see http://www.openrdf.org/");
    }

    public GraphDBConsole() throws IOException {
        this.appConfig.init();
        this.consoleIO = new ConsoleIO((ConsoleState)this);
        this.register((ConsoleSetting)new ConsoleWidth());
        this.register((ConsoleSetting)new LogLevel());
        this.register((ConsoleSetting)new Prefixes());
        this.register((ConsoleSetting)new QueryPrefix());
        this.register((ConsoleSetting)new ShowPrefix());
        this.register((ConsoleSetting)new WorkDir());
        this.commandMap.put("federate", (Command)new Federate(this.consoleIO, (ConsoleState)this));
        this.baseEval = new TupleAndGraphQueryEvaluator(this.consoleIO, (ConsoleState)this, this.settingsMap);
        this.queryEvaluator = new Sparql(this.baseEval);
        this.helpMap.put(this.queryEvaluator.getName(), (Help)this.queryEvaluator);
        Close close = new Close(this.consoleIO, (ConsoleState)this);
        this.commandMap.put(close.getName(), (Command)close);
        this.disconnect = new Disconnect(this.consoleIO, (ConsoleState)this, close);
        this.helpMap.put(this.disconnect.getName(), (Help)this.disconnect);
        this.commandMap.put("info", (Command)new PrintInfo(this.consoleIO, (ConsoleState)this));
        this.connect = new GraphDBConnect(this.consoleIO, this, this.disconnect);
        this.commandMap.put(this.connect.getName(), (Command)this.connect);
        this.commandMap.put("create", (Command)new GraphDBCreate(this.consoleIO, new ConsoleStateForCreate(this)));
        this.commandMap.put("drop", (Command)new Drop(this.consoleIO, (ConsoleState)this, close));
        this.open = new Open(this.consoleIO, (ConsoleState)this, close);
        this.commandMap.put(this.open.getName(), (Command)this.open);
        this.commandMap.put("show", (Command)new Show(this.consoleIO, (ConsoleState)this));
        this.commandMap.put("load", (Command)new Load(this.consoleIO, (ConsoleState)this, this.settingsMap));
        this.commandMap.put("verify", (Command)new Verify(this.consoleIO, this.settingsMap));
        this.commandMap.put("clear", (Command)new Clear(this.consoleIO, (ConsoleState)this));
        this.commandMap.put("set", (Command)new SetParameters(this.consoleIO, (ConsoleState)this, this.settingsMap));
        this.export = new Export(this.consoleIO, (ConsoleState)this, this.settingsMap);
        this.commandMap.put(this.export.getName(), (Command)this.export);
        this.commandMap.put("help", (Command)new PrintHelp(this.consoleIO, this.helpMap));
        for (Map.Entry<String, Command> e : this.commandMap.entrySet()) {
            if (!(e.getValue() instanceof Help)) continue;
            this.helpMap.put(e.getKey(), (Help)e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.consoleIO.writeln("Sesame Console, an interactive shell to communicate with Sesame repositories.");
        this.consoleIO.writeln();
        this.consoleIO.writeln("Type 'help' for help.");
        int exitCode = 0;
        try {
            boolean exitFlag = false;
            while (!exitFlag) {
                String command = this.consoleIO.readCommand();
                if (command == null) {
                    break;
                }
                exitFlag = this.executeCommand(command);
                if (!exitOnError || !this.consoleIO.wasErrorWritten()) continue;
                exitCode = 2;
                exitFlag = true;
            }
        }
        finally {
            this.disconnect.execute(false);
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
        this.consoleIO.writeln("Bye");
    }

    private boolean executeCommand(String command) throws IOException {
        boolean exit = false;
        if (0 < command.length()) {
            String[] tokens = this.parse(command);
            String operation = tokens[0].toLowerCase(Locale.ENGLISH);
            boolean bl = exit = "quit".equals(operation) || "exit".equals(operation);
            if (!exit) {
                if (this.commandMap.containsKey(operation)) {
                    this.commandMap.get(operation).execute(tokens);
                } else if ("disconnect".equals(operation)) {
                    this.disconnect.execute(true);
                } else {
                    this.queryEvaluator.executeQuery(command, operation);
                }
            }
        }
        return exit;
    }

    private String[] parse(String command) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
        Matcher matcher = pattern.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                tokens.add(matcher.group());
                continue;
            }
            tokens.add(matcher.group(1));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public String getApplicationName() {
        return this.appConfig.getFullName();
    }

    public File getDataDirectory() {
        return this.appConfig.getDataDir();
    }

    public String getManagerID() {
        return this.managerID;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public RepositoryManager getManager() {
        return this.manager;
    }

    public void setManager(RepositoryManager manager) {
        this.manager = manager;
    }

    public void setManagerID(String managerID) {
        this.managerID = managerID;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepositoryID(String repositoryID) {
        this.repositoryID = repositoryID;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public int getWidth() {
        return this.consoleWidth;
    }

    public void setWidth(int width) {
        this.consoleWidth = width;
    }

    public boolean isShowPrefix() {
        return this.showPrefix;
    }

    public void setShowPrefix(boolean value) {
        this.showPrefix = value;
    }

    public boolean isQueryPrefix() {
        return this.queryPrefix;
    }

    public void setQueryPrefix(boolean value) {
        this.queryPrefix = value;
    }

    public void register(ConsoleSetting setting) {
        this.settingsMap.put(setting.getName(), setting);
    }
}

