/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.server;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.server.TomcatMimeTypes;
import jakarta.servlet.MultipartConfigElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Security;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBTomcat
extends Tomcat {
    private final Logger logger;

    public GraphDBTomcat() throws IOException {
        this("graphdb");
    }

    public GraphDBTomcat(String baseDirPrefix) throws IOException {
        this.setBaseDir(Config.createTempDirectoryIfNeeded((String)baseDirPrefix).toString());
        this.logger = LoggerFactory.getLogger(GraphDBTomcat.class);
    }

    public void setConnectorProperties(Map<String, String> connectorProperties, int initPort) {
        this.setPort(initPort);
        Connector connector = this.getConnector();
        this.enableTomcatCompression(connector);
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        SSLHostConfigCertificate sslCert = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        for (Map.Entry<String, String> p : connectorProperties.entrySet()) {
            if (p.getKey().startsWith("ssl.")) {
                String value;
                String sslProp = p.getKey().substring("ssl.".length());
                if (IntrospectionUtils.setProperty((Object)sslCert, (String)sslProp, (String)(value = p.getValue())) || IntrospectionUtils.setProperty((Object)sslHostConfig, (String)sslProp, (String)value)) continue;
                this.logger.warn("Ignoring unknown Tomcat SSL property: graphdb.connector.{}", (Object)p.getKey());
                continue;
            }
            if (IntrospectionUtils.setProperty((Object)connector, (String)p.getKey(), (String)p.getValue())) continue;
            connector.setProperty(p.getKey(), p.getValue());
        }
        if (connector.getProperty("SSLEnabled").toString().equals("true")) {
            sslHostConfig.addCertificate(sslCert);
            connector.addSslHostConfig(sslHostConfig);
        }
        if (this.isX509AuthConfigured()) {
            this.enableX509AuthFromConfiguration(connector);
        }
    }

    protected int getPort() {
        return this.getConnector().getLocalPort();
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        StandardContext ctx = new StandardContext(this){

            public void addChild(Container child) {
                if (child instanceof Wrapper && child.getName().equals("spring")) {
                    try {
                        ((Wrapper)child).setMultipartConfigElement(new MultipartConfigElement(Config.createTempDirectoryIfNeeded((String)"uploads").toString(), Config.getPropertyAsLong((String)"graphdb.workbench.maxUploadSize", (long)0x40000000L), -1L, 0));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                super.addChild(child);
            }
        };
        ctx.setDelegate(true);
        ctx.setPrivileged(true);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.setWorkDir(this.basedir);
        ctx.setResources((WebResourceRoot)new StandardRoot(this, (Context)ctx){

            protected void registerURLStreamHandlerFactory() {
            }
        });
        ((StandardJarScanner)ctx.getJarScanner()).setScanAllDirectories(false);
        ((StandardJarScanner)ctx.getJarScanner()).setScanManifest(false);
        ctx.addLifecycleListener(config);
        ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        if (host == null) {
            this.getHost().addChild((Container)ctx);
        } else {
            host.addChild((Container)ctx);
        }
        int i = 0;
        while (i < TomcatMimeTypes.DEFAULT_MIME_MAPPINGS.length) {
            ctx.addMimeMapping(TomcatMimeTypes.DEFAULT_MIME_MAPPINGS[i++], TomcatMimeTypes.DEFAULT_MIME_MAPPINGS[i++]);
        }
        ctx.setClearReferencesRmiTargets(false);
        ctx.setClearReferencesThreadLocals(false);
        ctx.addLifecycleListener(event -> {
            Path workDir;
            if ("stop".equals(event.getType()) && (workDir = Path.of(this.basedir, new String[0])).toFile().exists() && workDir.toFile().isDirectory()) {
                try (Stream<Path> paths = Files.walk(workDir, new FileVisitOption[0]);){
                    paths.filter(path -> !path.equals(workDir)).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (Exception e) {
                    this.logger.error("Failed to clean work directory", (Throwable)e);
                }
            }
        });
        return ctx;
    }

    private void enableX509AuthFromConfiguration(Connector connector) {
        boolean ocspEnabled = Config.getPropertyAsBoolean((String)"graphdb.auth.methods.x509.ocsp", (boolean)true);
        boolean crldpEnabled = Config.getPropertyAsBoolean((String)"graphdb.auth.methods.x509.crldp", (boolean)true);
        Security.setProperty("ocsp.enable", Boolean.toString(ocspEnabled));
        System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(crldpEnabled));
        SSLHostConfig[] sslHostConfigs = connector.findSslHostConfigs();
        assert (sslHostConfigs.length == 1);
        SSLHostConfig sslHostConfig = sslHostConfigs[0];
        sslHostConfig.setRevocationEnabled(ocspEnabled || crldpEnabled);
        sslHostConfig.setCertificateRevocationListFile(Config.getProperty((String)"graphdb.auth.methods.x509.crlFile"));
        sslHostConfig.setCertificateVerification(this.onlyX509AuthEnabled() ? "required" : "optional");
    }

    private boolean onlyX509AuthEnabled() {
        return StringUtils.containsOnly((CharSequence)Config.getProperty((String)"graphdb.auth.methods"), (String)"x509");
    }

    private boolean isX509AuthConfigured() {
        return StringUtils.containsAny((CharSequence)Config.getProperty((String)"graphdb.auth.methods"), (CharSequence)"x509");
    }

    private void enableTomcatCompression(Connector connector) {
        connector.setProperty("compression", "on");
        connector.setProperty("noCompressionUserAgents", "gozilla, traviata");
        connector.setProperty("compressibleMimeType", "text/turtle, application/x-turtle,application/trig, application/x-trig, application/x-trigstar, text/n3,text/rdf+n3, application/n-triples, text/plain, application/n-quads, text/x-nquads,text/nquads, application/ld+json, application/x-ld+ndjson, application/rdf+json,application/rdf+xml, application/xml, text/xml, application/trix,text/html, text/css, text/javascript, application/javascript, application/json, application/xml");
    }

    static {
        System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
    }
}

