/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.server;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.GraphDBRepositoryManagerHolder;
import com.ontotext.graphdb.report.StateReport;
import com.ontotext.graphdb.security.TokenManager;
import com.ontotext.graphdb.server.GraphDBTomcat;
import com.ontotext.graphdb.server.Util;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.enums.StatisticsEvent;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.trree.statistics.StatisticsSettings;
import com.ontotext.trree.statistics.StatisticsThread;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDB {
    public static final String GRAPHDB_WORKBENCH_HOME = "graphdb.workbench.home";
    public static int DEFAULT_PORT;
    private Mode mode;
    private Logger logger;
    private boolean isInTestMode = false;
    private final GraphDBTomcat tomcat;
    private AtomicBoolean stopped = new AtomicBoolean();

    public GraphDB(Mode mode) throws IOException {
        this(DEFAULT_PORT, mode);
    }

    public GraphDB(int port, Mode mode) throws IOException {
        this.mode = mode;
        this.tomcat = new GraphDBTomcat(mode.getTempFolderPrefix());
        this.init(port);
        Context context = this.tomcat.addWebapp(this.tomcat.getHost(), "", mode.getWebappDirectory());
        String extraLibDirectory = mode.getExtraLibDirectory();
        if (extraLibDirectory != null) {
            WebResourceRoot resources = context.getResources();
            resources.addPreResources((WebResourceSet)new DirResourceSet(resources, "/", extraLibDirectory, "/"));
            if (Mode.WORKBENCH.equals((Object)mode) || Mode.NATIVE.equals((Object)mode)) {
                resources.addPreResources((WebResourceSet)new DirResourceSet(resources, "/", Config.getUIDirectory(), "/"));
            }
        }
        StateReport.registerMXBean();
    }

    public GraphDB(int port, Mode mode, boolean isInTestMode) throws IOException {
        this(port, mode);
        this.isInTestMode = isInTestMode;
        this.tomcat.getEngine().setName("GraphDBTomcat" + System.identityHashCode((Object)this.tomcat));
    }

    private void init(int port) {
        this.logger = LoggerFactory.getLogger(GraphDB.class);
        this.tomcat.setConnectorProperties(Config.getConnectorProperties(), port);
    }

    public void start() throws LifecycleException, IOException {
        LicenseRegistry.getInstance().setClusterProxyMode(this.mode == Mode.CLUSTER_PROXY);
        if (this.getPort() > 0 && !Util.portIsAvailable(this.getPort())) {
            this.handlePortBusy();
            return;
        }
        this.tomcat.init();
        this.processSSLCertificate();
        this.logger.info("Starting {} in {} mode.", (Object)this.mode.getDisplayName(), (Object)this.mode);
        this.tomcat.start();
        this.logger.info("Started {} in {} mode at port {}.", new Object[]{this.mode.getDisplayName(), this.mode, this.getPort()});
        String pidFile = Config.getProperty((String)"graphdb.pidfile");
        if (pidFile != null) {
            try {
                Util.writePidFile(pidFile);
            }
            catch (Exception e) {
                this.logger.warn("Unable to write PID to file: " + pidFile, (Throwable)e);
            }
        }
        Config.configureHeapDumpFile();
        StatisticsThread statisticsThread = new StatisticsThread((StatisticsListener)SystemStatisticsCollector.getInstance());
        if (StatisticsSettings.getInstance().isStatisticsEnabled()) {
            SystemStatisticsCollector.getInstance().setEvent(StatisticsEvent.INITIALIZE);
        }
        statisticsThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                statisticsThread.shutdown();
                if (statisticsThread.isAlive()) {
                    this.logger.warn("statistics thread is still alive");
                }
                this.stop();
            }
            catch (LifecycleException e) {
                e.printStackTrace();
            }
        }));
    }

    public void stop() throws LifecycleException {
        if (!this.stopped.getAndSet(true)) {
            this.logger.info("Stopping {}.", (Object)this.mode.getDisplayName());
            this.tomcat.stop();
            this.tomcat.destroy();
        }
    }

    public synchronized void waitForever() {
        boolean logKeepAlive = Config.getPropertyAsBoolean((String)"graphdb.log.keepalive", (boolean)true);
        long lastKeepAliveEpoch = 0L;
        while (true) {
            try {
                while (true) {
                    Thread.sleep(60000L);
                    if (!logKeepAlive) continue;
                    ZonedDateTime zdt = ZonedDateTime.now();
                    long epoch = zdt.getLong(ChronoField.INSTANT_SECONDS);
                    if (zdt.getHour() != 0 || zdt.getMinute() >= 5 || epoch - lastKeepAliveEpoch <= 600L) continue;
                    this.logger.info("{} log keep alive message", (Object)this.mode.getDisplayName());
                    lastKeepAliveEpoch = epoch;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public int getPort() {
        return this.tomcat.getPort();
    }

    public GraphDBTomcat getTomcat() {
        return this.tomcat;
    }

    public void shutdownRepository(String repositoryId) {
        GraphDBRepositoryManager repositoryManager = GraphDBRepositoryManagerHolder.getRepositoryManager();
        if (repositoryManager == null) {
            throw new IllegalStateException("Repository manager not set.");
        }
        Repository repository = repositoryManager.getRepository(repositoryId);
        if (repository == null) {
            throw new IllegalArgumentException("Repository with id " + repositoryId + " not found.");
        }
        repository.shutDown();
    }

    public void removeRepositoryAndKeepData(String repositoryId) {
        GraphDBRepositoryManager repositoryManager = GraphDBRepositoryManagerHolder.getRepositoryManager();
        if (repositoryManager == null) {
            throw new IllegalStateException("Repository manager not set.");
        }
        repositoryManager.removeRepository(repositoryId, true);
    }

    public void handlePortBusy() throws LifecycleException {
        if (this.isInTestMode) {
            throw new LifecycleException("Port " + this.getPort() + " is busy. " + this.mode.getDisplayName() + " cannot be started.");
        }
        this.logger.error("Port {} is busy. {} cannot be started.", (Object)this.getPort(), (Object)this.mode.getDisplayName());
        System.exit(1);
    }

    private void processSSLCertificate() {
        SSLHostConfigCertificate cert = this.getSSLCertificate();
        if (cert != null) {
            this.setupSSLContext(cert);
            this.checkTokenSecret(cert);
        }
    }

    private void checkTokenSecret(SSLHostConfigCertificate cert) {
        TokenManager tokenManager = TokenManager.getInstance();
        if (!tokenManager.hasConfiguredSecret()) {
            try {
                String alias = Optional.ofNullable(cert.getCertificateKeyAlias()).orElse("tomcat");
                PrivateKey key = ((X509KeyManager)new JSSEUtil(cert).getKeyManagers()[0]).getPrivateKey(alias);
                byte[] keyBytes = key.getEncoded();
                if (keyBytes.length >= 48) {
                    byte[] tokenSecret = new byte[16];
                    System.arraycopy(keyBytes, 32, tokenSecret, 0, 16);
                    tokenManager.setTokenSecretBytes(tokenSecret);
                }
            }
            catch (Exception e) {
                this.logger.warn("Cannot derive auth secret from certificate. Using random secret.", (Throwable)e);
            }
        }
    }

    private void setupSSLContext(SSLHostConfigCertificate cert) {
        try {
            String alias = Optional.ofNullable(cert.getCertificateKeyAlias()).orElse("tomcat");
            JSSEUtil jsseUtil = new JSSEUtil(cert);
            KeyManager[] keyManagers = jsseUtil.getKeyManagers();
            TrustManager[] trustManagers = jsseUtil.getTrustManagers();
            X509Certificate[] certificateChain = ((X509KeyManager)keyManagers[0]).getCertificateChain(alias);
            if (certificateChain == null) {
                this.logger.warn("The configured key store does not contain an SSL certificate chain under the alias {}, exiting.", (Object)alias);
                System.exit(1);
            }
            Config.setTLSContext((KeyManager[])keyManagers, (TrustManager[])trustManagers);
            Config.setRpcTLS((X509Certificate[])certificateChain, (KeyManager[])keyManagers, (TrustManager[])trustManagers);
            Config.setOwnSSLCertificate((X509Certificate[])certificateChain);
        }
        catch (Exception e) {
            this.logger.warn("Cannot configure internal SSL context, exiting, ", (Throwable)e);
            System.exit(1);
        }
    }

    private SSLHostConfigCertificate getSSLCertificate() {
        SSLHostConfig sslHostConfig;
        Set certificates;
        SSLHostConfig[] sslHostConfigs = this.tomcat.getConnector().findSslHostConfigs();
        if (sslHostConfigs.length > 0 && !(certificates = (sslHostConfig = sslHostConfigs[0]).getCertificates()).isEmpty()) {
            return (SSLHostConfigCertificate)certificates.iterator().next();
        }
        return null;
    }

    static {
        Util.configureServerLogging();
        DEFAULT_PORT = 7200;
    }

    public static enum Mode {
        WORKBENCH("workbench", "GraphDB"),
        SERVER("server only", "GraphDB"),
        NATIVE("native", "GraphDB"),
        CLUSTER_PROXY("proxy", "GraphDB Cluster Proxy");

        private final String humanReadable;
        private final String displayName;
        private final String tempFolderPrefix;

        private Mode(String humanReadable, String displayName) {
            this.humanReadable = humanReadable;
            this.displayName = displayName;
            this.tempFolderPrefix = displayName.toLowerCase().replace(' ', '-');
        }

        public String toString() {
            return this.humanReadable;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTempFolderPrefix() {
            return this.tempFolderPrefix;
        }

        public String getWebappDirectory() {
            switch (this.ordinal()) {
                case 0: 
                case 2: {
                    return Paths.get(Config.getDistDirectory(), "lib", "framework").toString();
                }
                case 1: {
                    return Paths.get(Config.getDistDirectory(), "lib", "server").toString();
                }
                case 3: {
                    return Paths.get(Config.getDistDirectory(), "lib", "cluster-proxy-app").toString();
                }
            }
            throw new RuntimeException("Unsupported mode: " + String.valueOf((Object)this));
        }

        public String getExtraLibDirectory() {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    return Paths.get(Config.getDistDirectory(), "lib", "common").toString();
                }
                case 3: {
                    return null;
                }
            }
            throw new RuntimeException("Unsupported mode: " + String.valueOf((Object)this));
        }
    }
}

