/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.generator.jsonld;

import com.ontotext.metamodel.generator.jsonld.JsonLdContextOptions;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.soaas.common.StringManipulation;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;

class JsonLdContextGenerator {
    private static final String SO_TYPE = "so:type";
    private static final String SO_NAME = "so:name";
    private final Set<String> reservedWords;
    private final SomlSchema soml;
    private final Prefixes prefixes;
    private final SpecialPrefixes specialPrefixes;
    private final Map<String, String> scalarToXsdType;
    private final JsonLdContextOptions contextOptions;

    JsonLdContextGenerator(SomlSchema soml) {
        this(soml, new JsonLdContextOptions());
    }

    JsonLdContextGenerator(SomlSchema soml, JsonLdContextOptions contextOptions) {
        this.soml = soml;
        this.contextOptions = contextOptions;
        this.prefixes = soml.getPrefixes();
        this.specialPrefixes = soml.getSpecialPrefixes();
        this.scalarToXsdType = soml.getTypes().toXsdTypeMapping();
        this.reservedWords = new HashSet<String>();
        this.reservedWords.addAll(contextOptions.getIgnoredTypes());
        Stream.of(contextOptions.getIdAlias(), contextOptions.getTypeAlias(), contextOptions.getLangAlias(), contextOptions.getValueAlias(), contextOptions.getBoNameAlias(), contextOptions.getBoTypeAlias()).filter(Objects::nonNull).forEach(this.reservedWords::add);
    }

    Map<String, Object> generateContext() {
        Map<String, Object> context = this.createInitialContext();
        context.putAll(this.getPrefixes());
        context.putAll(this.getDefaultBusinessProperties());
        context.putAll(this.readClassProperties());
        return context;
    }

    private Map<String, Object> createInitialContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(32);
        this.setAlias(context, this.contextOptions.getIdAlias(), "@id");
        this.setAlias(context, this.contextOptions.getTypeAlias(), "@type");
        this.setAlias(context, this.contextOptions.getLangAlias(), "@language");
        this.setAlias(context, this.contextOptions.getValueAlias(), "@value");
        this.specialPrefixes.getVocabIri().ifPresent(vocab -> context.put("@vocab", vocab));
        this.specialPrefixes.getBaseIri().ifPresent(base -> context.put("@base", base));
        return context;
    }

    private void setAlias(Map<String, Object> context, String alias, String aliased) {
        if (alias != null && !aliased.equals(alias)) {
            context.put(alias, aliased);
        }
    }

    private Map<String, Object> getPrefixes() {
        LinkedHashMap<String, Object> prefixesCopy = new LinkedHashMap<String, Object>((Map<String, Object>)this.prefixes);
        this.contextOptions.getIgnoredPrefixes().forEach(prefixesCopy::remove);
        return prefixesCopy;
    }

    private Map<String, Object> getDefaultBusinessProperties() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        Properties properties = this.soml.getProperties();
        BiConsumer<String, String> businessPropsRegister = (alias, aliased) -> {
            if (alias != null && properties.containsKey(aliased)) {
                PropertyShape propertyShape = (PropertyShape)properties.get(aliased);
                context.put((String)alias, this.createTypeInfo((String)aliased, propertyShape));
            }
        };
        businessPropsRegister.accept(this.contextOptions.getBoTypeAlias(), SO_TYPE);
        businessPropsRegister.accept(this.contextOptions.getBoNameAlias(), SO_NAME);
        return context;
    }

    private Map<String, Object> readClassProperties() {
        Shapes objects = this.soml.getObjects();
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        objects.values().stream().filter(shape -> !this.reservedWords.contains(shape.getId())).forEach(shape -> this.mergePropertyDefinitions(context, this.readProperties((Shape)shape)));
        return context;
    }

    private void mergePropertyDefinitions(Map<String, Object> context, Map<String, Object> properties) {
        properties.forEach((key, value) -> context.merge((String)key, value, this.mergePropertyDefinition((String)key)));
    }

    private BiFunction<Object, Object, Object> mergePropertyDefinition(String key) {
        return (oldValue, value) -> {
            boolean isOldValueMap = oldValue instanceof Map;
            boolean isValueMap = value instanceof Map;
            if (!isOldValueMap && !isValueMap) {
                JsonLdContextGenerator.checkSame(key, "@id", oldValue, value);
                return value;
            }
            if (!isOldValueMap) {
                Object id = ((Map)value).get("@id");
                JsonLdContextGenerator.checkSame(key, "@id", oldValue, id);
                return value;
            }
            if (!isValueMap) {
                Object id = ((Map)oldValue).get("@id");
                JsonLdContextGenerator.checkSame(key, "@id", id, value);
                return oldValue;
            }
            Object oldId = ((Map)oldValue).get("@id");
            Object id = ((Map)value).get("@id");
            JsonLdContextGenerator.checkSame(key, "@id", oldId, id);
            Object oldType = ((Map)oldValue).get("@type");
            Object type = ((Map)value).get("@type");
            JsonLdContextGenerator.checkSame(key, "@type", oldType, type);
            return oldValue;
        };
    }

    private static void checkSame(String key, String id, Object oldValue, Object value) {
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue == null || value == null || !oldValue.equals(value)) {
            throw new InvalidSchemaException(String.format("The field %s points to a different %s [%s, %s]", key, id, oldValue, value));
        }
    }

    private Map<String, Object> readProperties(Shape classData) {
        Properties propertiesDefinitions = classData.getProps();
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        propertiesDefinitions.forEach((key, type) -> {
            if (!this.reservedWords.contains(key)) {
                context.put(JsonLdContextGenerator.toNonIriName(key), this.createTypeInfo((String)key, (PropertyShape)type));
            }
        });
        return context;
    }

    private static String toNonIriName(String key) {
        return StringManipulation.replaceColonWithUnderscore((String)key);
    }

    private Object createTypeInfo(String propertyName, PropertyShape propertyDefinition) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>(6);
        if (propertyDefinition.getInverseAlias() == null) {
            info.put("@id", this.prefixes.toShortIri(propertyName));
        } else {
            info.put("@reverse", propertyDefinition.getInverseAlias());
        }
        String resolvedType = this.resolveType(propertyDefinition.getRange());
        if (resolvedType != null) {
            info.put("@type", resolvedType);
        }
        if (propertyDefinition.isMultivalued()) {
            info.put("@container", "@set");
        }
        if (info.size() == 1 && info.containsKey("@id")) {
            return info.get("@id");
        }
        return info;
    }

    private String resolveType(String type) {
        if ("id".equals(type)) {
            return "@id";
        }
        if (this.isScalar(type)) {
            String xsdType = this.scalarToXsdType.get(type);
            if (!this.contextOptions.isUseXsdString() && "xsd:string".equals(xsdType)) {
                return null;
            }
            return xsdType;
        }
        return null;
    }

    private boolean isScalar(String type) {
        return this.scalarToXsdType.containsKey(type);
    }
}

