/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.generator.jsonld;

import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.ontotext.metamodel.generator.JsonLdTransformer;
import com.ontotext.metamodel.generator.jsonld.JsonLdFrameGenerator;
import com.ontotext.metamodel.generator.jsonld.JsonLdFrameOptions;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.QueryParser;
import com.ontotext.rbac.SecurityContext;
import java.util.Map;
import java.util.Objects;

public class FramedJsonLdTransformer
implements JsonLdTransformer {
    private final JsonLdFrameGenerator frameGenerator;
    private final QueryParser queryParser;

    public FramedJsonLdTransformer(SomlSchema somlSchema, QueryParser queryParser) {
        this.frameGenerator = new JsonLdFrameGenerator(Objects.requireNonNull(somlSchema, "Soml schema is required"));
        this.queryParser = Objects.requireNonNull(queryParser, "Query parser is required!");
    }

    public FramedJsonLdTransformer(SomlSchema somlSchema, QueryParser queryParser, JsonLdFrameOptions jsonLdFrameOptions) {
        this.frameGenerator = new JsonLdFrameGenerator(Objects.requireNonNull(somlSchema, "Soml schema is required"), jsonLdFrameOptions);
        this.queryParser = Objects.requireNonNull(queryParser, "Query parser is required!");
    }

    @Override
    public Object transform(String query, Object jsonLd) {
        Query parsedQuery = (Query)this.queryParser.parse((Object)query, SecurityContext.empty());
        Map<String, Object> frame = this.frameGenerator.getFrame(parsedQuery);
        return JsonLdProcessor.frame((Object)jsonLd, frame, (JsonLdOptions)FramedJsonLdTransformer.getDefaultJsonLdOptions());
    }

    private static JsonLdOptions getDefaultJsonLdOptions() {
        JsonLdOptions options = new JsonLdOptions();
        options.setEmbed("@always");
        options.setExplicit(Boolean.valueOf(true));
        options.setOmitDefault(Boolean.valueOf(true));
        return options;
    }
}

