/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import it.unibz.inf.ontop.answering.connection.JDBCStatementInitializer;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.injection.impl.OntopReformulationSQLSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialSettingsImpl;
import it.unibz.inf.ontop.injection.impl.OntopSystemSettingsImpl;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class OntopSystemSQLSettingsImpl
extends OntopReformulationSQLSettingsImpl
implements OntopSystemSQLSettings {
    private static final String DEFAULT_FILE = "system-sql-default.properties";
    private static final String STATEMENT_INITIALIZER_SUFFIX = "-statementInitializer";
    private final OntopSystemSettings systemSettings = new OntopSystemSettingsImpl(this.copyProperties());
    private final OntopSQLCredentialSettings sqlCredentialSettings = new OntopSQLCredentialSettingsImpl(this.copyProperties());

    OntopSystemSQLSettingsImpl(Properties userProperties) {
        super(OntopSystemSQLSettingsImpl.loadProperties(userProperties));
    }

    private static Properties loadProperties(Properties userProperties) {
        Properties properties = OntopSystemSQLSettingsImpl.loadDefaultSystemSQLProperties();
        properties.putAll((Map<?, ?>)userProperties);
        String jdbcDriver = OntopSQLCoreSettingsImpl.extractJdbcDriver((Properties)userProperties);
        String initializerKey = jdbcDriver + STATEMENT_INITIALIZER_SUFFIX;
        String initializerName = JDBCStatementInitializer.class.getCanonicalName();
        Optional.ofNullable(properties.getProperty(initializerKey)).filter(v -> !userProperties.containsKey(initializerName)).ifPresent(v -> properties.setProperty(initializerName, (String)v));
        return properties;
    }

    static Properties loadDefaultSystemSQLProperties() {
        Properties properties = OntopSystemSettingsImpl.loadDefaultSystemProperties();
        properties.putAll((Map<?, ?>)OntopSystemSQLSettingsImpl.loadDefaultPropertiesFromFile(OntopSystemSQLSettings.class, (String)DEFAULT_FILE));
        return properties;
    }

    @Override
    public boolean isKeepAliveEnabled() {
        return this.getRequiredBoolean("jdbc.pool.keepAlive");
    }

    @Override
    public boolean isRemoveAbandonedEnabled() {
        return this.getRequiredBoolean("jdbc.pool.removeAbandoned");
    }

    @Override
    public int getConnectionTimeout() {
        return this.getRequiredInteger("jdbc.pool.connectionTimeout");
    }

    @Override
    public int getConnectionPoolInitialSize() {
        return this.getRequiredInteger("jdbc.pool.initialSize");
    }

    @Override
    public int getConnectionPoolMaxSize() {
        return this.getRequiredInteger("jdbc.pool.maxSize");
    }

    @Override
    public int getFetchSize() {
        return this.getRequiredInteger("jdbc.fetchSize");
    }

    public Optional<Integer> getDefaultQueryTimeout() {
        return this.getInteger("ontop.query.defaultTimeout");
    }

    public boolean isPermanentDBConnectionEnabled() {
        return this.systemSettings.isPermanentDBConnectionEnabled();
    }

    public Optional<String> getHttpCacheControl() {
        return this.systemSettings.getHttpCacheControl();
    }

    public Optional<String> getJdbcUser() {
        return this.sqlCredentialSettings.getJdbcUser();
    }

    public Optional<String> getJdbcPassword() {
        return this.sqlCredentialSettings.getJdbcPassword();
    }

    public Properties getAdditionalJDBCProperties() {
        return this.sqlCredentialSettings.getAdditionalJDBCProperties();
    }
}

