/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.pool.impl;

import com.google.inject.Inject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool;
import it.unibz.inf.ontop.injection.OntopSystemSQLSettings;
import java.sql.Connection;
import java.sql.SQLException;

public class HikariConnectionPool
implements JDBCConnectionPool {
    private final HikariDataSource ds;

    @Inject
    private HikariConnectionPool(OntopSystemSQLSettings settings) {
        HikariConfig config = new HikariConfig();
        config.setDataSourceProperties(settings.getAdditionalJDBCProperties());
        config.setJdbcUrl(settings.getJdbcUrl());
        settings.getJdbcUser().ifPresent(arg_0 -> ((HikariConfig)config).setUsername(arg_0));
        settings.getJdbcPassword().ifPresent(arg_0 -> ((HikariConfig)config).setPassword(arg_0));
        config.setDriverClassName(settings.getJdbcDriver());
        config.setMinimumIdle(settings.getConnectionPoolInitialSize());
        config.setMaximumPoolSize(settings.getConnectionPoolMaxSize());
        config.setConnectionTimeout((long)settings.getConnectionTimeout());
        config.setReadOnly(true);
        this.ds = new HikariDataSource(config);
    }

    @Override
    public void close() {
        this.ds.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }
}

