/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import com.ontotext.graphql.PropertyChangeUtil;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.MutationValidator;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.soaas.common.CollectionsUtil;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.language.SourceLocation;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SingleValueChangeValidator
extends MutationValidator {
    public OperationResponse validate(Operation operation, ValidationContext context) {
        if (operation.getOperationType() != OperationType.CREATE && operation.getOperationType() != OperationType.UPDATE || !context.getValidatorOptions().isValidatorEnabled(((Object)((Object)this)).getClass().getSimpleName())) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        for (Change change : ((Mutation)operation).getChanges()) {
            this.validateChange(change, response);
        }
        return response;
    }

    private void validateChange(Change change, OperationResponse response) {
        Shape shape = change.getShape();
        for (List<PropertyChange> changeList : PropertyChangeUtil.getSanitizedGroupedChanges(change, PropertyChange::getName, Stream.of(PropertyChangeUtil.hasScalarProperty(shape), PropertyChangeUtil.hasMultiValuedProperty(shape)).collect(Collectors.toList()))) {
            this.checkForMultipleUpdates(response, changeList);
        }
    }

    private void checkForMultipleUpdates(OperationResponse response, List<PropertyChange> changeList) {
        LinkedHashSet valuesToAdd = new LinkedHashSet();
        LinkedHashSet valuesToRemove = new LinkedHashSet();
        boolean hasConditions = PropertyChange.sortValuesForChanges(valuesToAdd, valuesToRemove, changeList);
        if (valuesToAdd.size() == 1 && valuesToRemove.size() == 1) {
            return;
        }
        CollectionsUtil.cleanDuplicates(valuesToAdd, valuesToRemove);
        if (valuesToAdd.size() > 1) {
            response.addErrorMessage(this.getMultipleIdsMessage(changeList));
        } else if (changeList.size() > 1 && hasConditions) {
            response.addErrorMessage(this.couldNotCollapseValues(changeList));
        }
    }

    private Serializable couldNotCollapseValues(List<PropertyChange> propertyChanges) {
        return this.createError(propertyChanges, "mutation.update.cannotCollapseMultipleChanges", propertyChanges.size());
    }

    private Serializable getMultipleIdsMessage(List<PropertyChange> propertyChanges) {
        return this.createError(propertyChanges, "mutation.update.expected.single.value.property", this.getValuesCount(propertyChanges));
    }

    private Serializable createError(List<PropertyChange> propertyChanges, String messageId, int count) {
        PropertyChange propertyChange = propertyChanges.get(0);
        String message = ErrorMessages.get((String)messageId, (Object[])new Object[]{propertyChange.getName(), count});
        return (Serializable)((Object)new SimpleGraphQlError(message, this.convertLocations(propertyChanges), (ErrorClassification)ErrorType.ValidationError).toSpecification());
    }

    private int getValuesCount(List<PropertyChange> propertyChanges) {
        Set toAdd = propertyChanges.stream().map(PropertyChange::getRawValueAsCollection).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        Set removed = propertyChanges.stream().map(PropertyChange::getRawPatch).filter(Objects::nonNull).collect(Collectors.toSet());
        toAdd.removeAll(removed);
        return toAdd.size();
    }

    private List<SourceLocation> convertLocations(List<PropertyChange> propertyChanges) {
        return propertyChanges.stream().flatMap(propertyChange -> propertyChange.getSourceLocations().stream()).map(sl -> new SourceLocation(sl.getLine(), sl.getColumn())).distinct().collect(Collectors.toList());
    }
}

