/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import com.ontotext.graphql.parser.ArgumentCollector;
import com.ontotext.graphql.validator.ArgumentsValidator;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.graphql.validator.ValidatedQuery;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.SourceLocation;
import graphql.language.StringValue;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorType;
import graphql.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;

public class GraphQlValidator {
    private static final List<SourceLocation> DEFAULT_LOCATION = Collections.singletonList(new SourceLocation(0, 0));
    public static final String SEARCHED_STRING = ") : ";
    private GraphQLSchema schema;
    private Validator validator;
    private ArgumentsValidator argumentsValidator;
    private Parser parser;

    public GraphQlValidator(GraphQLSchema schema) {
        this.schema = schema;
        this.validator = new Validator();
        this.argumentsValidator = new ArgumentsValidator();
        this.parser = new Parser();
    }

    public ValidatedQuery validateQuery(String query) {
        ValidatedQuery result;
        try {
            result = new ValidatedQuery(this.parser.parseDocument(query));
        }
        catch (Exception exc) {
            return this.onSyntaxError(exc);
        }
        this.validator.validateDocument(this.schema, result.getParsedQuery(), Locale.getDefault()).stream().map(this.wrapError(result.getParsedQuery())).forEach(result::addError);
        result.getErrors().removeIf(error -> error.getMessage().matches(".*\\[.*\\].*") && error.getMessage().contains("is not a valid"));
        this.argumentsValidator.validateDocument(this.schema, result.getParsedQuery()).stream().map(this.wrapError(result.getParsedQuery())).forEach(result::addError);
        LinkedHashSet<GraphQLError> deduplicatedErrors = new LinkedHashSet<GraphQLError>(result.getErrors());
        result.setErrors(new LinkedList<GraphQLError>(deduplicatedErrors));
        return result;
    }

    private Function<ValidationError, SimpleGraphQlError> wrapError(Document parsedQuery) {
        return error -> {
            if ((error = this.simplifyValidationErrorDescription((ValidationError)error)).getDescription().startsWith("argument")) {
                return this.simplifyErrorMessage((ValidationError)error, parsedQuery);
            }
            return new SimpleGraphQlError((ValidationError)error);
        };
    }

    private ValidationError simplifyValidationErrorDescription(ValidationError error) {
        String msg = error.getDescription();
        int index = msg.indexOf(SEARCHED_STRING);
        if (msg.startsWith("Validation error") && index != -1) {
            ValidationError.Builder copyBuilder = ValidationError.newValidationError();
            copyBuilder.validationErrorType(error.getValidationErrorType());
            copyBuilder.extensions(error.getExtensions());
            copyBuilder.sourceLocations(error.getLocations());
            copyBuilder.queryPath(error.getQueryPath());
            msg = msg.substring(index + SEARCHED_STRING.length());
            copyBuilder.description(msg);
            return copyBuilder.build();
        }
        return error;
    }

    private SimpleGraphQlError simplifyErrorMessage(ValidationError error, Document parsedQuery) {
        if (error.getValidationErrorType() == ValidationErrorType.WrongType) {
            String description = error.getDescription();
            int argNameStart = description.indexOf(39);
            int argNameEnd = description.indexOf(39, argNameStart + 1);
            int valueStart = description.indexOf(39, argNameEnd + 1);
            int valueEnd = this.computeValueEnd(description, valueStart);
            String argument = description.substring(argNameStart + 1, argNameEnd);
            String[] argPath = argument.split("\\.");
            List queryPath = error.getQueryPath();
            ArgumentSelector argumentSelector = new ArgumentSelector(queryPath, Arrays.asList(argPath));
            new NodeTraverser().preOrder((NodeVisitor)argumentSelector, (Node)parsedQuery);
            List<Object> valuePath = argumentSelector.valuePath;
            if (valuePath != null) {
                StringBuilder builder = new StringBuilder(description);
                String value = !valuePath.isEmpty() ? Objects.toString(valuePath.get(0)).replace("=", ": ") : "null";
                String newMessage = builder.replace(valueStart + 1, valueEnd, value).toString();
                return new SimpleGraphQlError(newMessage, error.getLocations(), (ErrorClassification)error.getErrorType(), error.getQueryPath());
            }
        }
        return new SimpleGraphQlError(error);
    }

    private int computeValueEnd(String description, int valueStart) {
        int valueEnd = description.indexOf(" contains a field", valueStart);
        if (valueEnd > 0) {
            return valueEnd - 1;
        }
        valueEnd = description.indexOf(" is missing required fields", valueStart);
        if (valueEnd > 0) {
            return valueEnd - 1;
        }
        valueEnd = description.indexOf(" is not a valid", valueStart);
        if (valueEnd > 0) {
            return valueEnd - 1;
        }
        return description.lastIndexOf(39);
    }

    private ValidatedQuery onSyntaxError(Exception exc) {
        Object err = exc instanceof InvalidSyntaxException ? new InvalidSyntaxError((InvalidSyntaxException)exc) : (exc instanceof GraphQLError ? (GraphQLError)exc : new SimpleGraphQlError(exc.getMessage(), DEFAULT_LOCATION, (ErrorClassification)ErrorType.ValidationError));
        return new ValidatedQuery().addError((GraphQLError)err);
    }

    private static class ArgumentSelector
    extends NodeVisitorStub {
        private final Deque<String> queryPath;
        private final Deque<String> argPath;
        private List<Object> valuePath;

        private ArgumentSelector(List<String> queryPath, List<String> argPath) {
            this.queryPath = new LinkedList<String>(queryPath);
            this.argPath = new LinkedList<String>(argPath);
        }

        public TraversalControl visitArrayValue(ArrayValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                ArgumentCollector argumentCollector = new ArgumentCollector(Collections.emptyMap(), this::stringWrap);
                node.accept(null, (NodeVisitor)argumentCollector);
                this.valuePath.add(argumentCollector.getValue());
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitBooleanValue(BooleanValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                this.valuePath.add(node.isValue());
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitEnumValue(EnumValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                this.valuePath.add(node.getName());
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitFloatValue(FloatValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                this.valuePath.add(node.getValue());
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitIntValue(IntValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                this.valuePath.add(node.getValue());
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitObjectField(ObjectField node, TraverserContext<Node> context) {
            return this.onArgumentNode(node.getName());
        }

        public TraversalControl visitObjectValue(ObjectValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                ArgumentCollector argumentCollector = new ArgumentCollector(Collections.emptyMap(), this::stringWrap);
                node.accept(null, (NodeVisitor)argumentCollector);
                this.valuePath.add(argumentCollector.getValue());
            }
            return TraversalControl.CONTINUE;
        }

        private Object stringWrap(Object val) {
            if (val instanceof String) {
                return "\"" + String.valueOf(val) + "\"";
            }
            return val;
        }

        public TraversalControl visitStringValue(StringValue node, TraverserContext<Node> context) {
            if (this.valuePath != null) {
                this.valuePath.add(this.stringWrap(node.getValue()));
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitArgument(Argument node, TraverserContext<Node> context) {
            return this.onArgumentNode(node.getName());
        }

        private TraversalControl onArgumentNode(String name) {
            if (this.argPath.isEmpty()) {
                return TraversalControl.QUIT;
            }
            if (this.queryPath.isEmpty() && name.equals(this.argPath.peek())) {
                this.argPath.removeFirst();
                if (this.argPath.isEmpty()) {
                    this.valuePath = new LinkedList<Object>();
                }
            }
            return TraversalControl.CONTINUE;
        }

        public TraversalControl visitField(Field node, TraverserContext<Node> context) {
            if (this.queryPath.isEmpty()) {
                return TraversalControl.CONTINUE;
            }
            if (node.getName().equals(this.queryPath.peek())) {
                this.queryPath.removeFirst();
            }
            return TraversalControl.CONTINUE;
        }
    }

    private static class InvalidSyntaxError
    implements GraphQLError {
        private final InvalidSyntaxException ise;

        InvalidSyntaxError(InvalidSyntaxException ise) {
            this.ise = ise;
        }

        public String getMessage() {
            return this.ise.getMessage();
        }

        public List<SourceLocation> getLocations() {
            return this.ise.getLocation() == null ? null : Collections.singletonList(this.ise.getLocation());
        }

        public ErrorClassification getErrorType() {
            return ErrorType.InvalidSyntax;
        }

        public String toString() {
            return this.toSpecification().toString();
        }
    }
}

