/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.validator;

import com.ontotext.graphql.validator.AllArgumentsOfCorrectType;
import graphql.i18n.I18n;
import graphql.language.Document;
import graphql.language.Node;
import graphql.schema.GraphQLSchema;
import graphql.validation.AbstractRule;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.RulesVisitor;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ArgumentsValidator {
    ArgumentsValidator() {
    }

    List<ValidationError> validateDocument(GraphQLSchema schema, Document document) {
        ValidationContext validationContext = new ValidationContext(schema, document, I18n.i18n((I18n.BundleType)I18n.BundleType.Validation, (Locale)Locale.getDefault()));
        ValidationErrorCollector validationErrorCollector = new ValidationErrorCollector();
        List<AbstractRule> rules = this.createRules(validationContext, validationErrorCollector);
        LanguageTraversal languageTraversal = new LanguageTraversal();
        languageTraversal.traverse((Node)document, (DocumentVisitor)new RulesVisitor(validationContext, rules));
        return validationErrorCollector.getErrors();
    }

    private List<AbstractRule> createRules(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        ArrayList<AbstractRule> rules = new ArrayList<AbstractRule>();
        AllArgumentsOfCorrectType argumentsOfCorrectType = new AllArgumentsOfCorrectType(validationContext, validationErrorCollector);
        rules.add(argumentsOfCorrectType);
        return rules;
    }
}

