/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.TraversalControl;
import java.util.List;

public class RemoveExistsOnSingleValueProperties
extends AbstractFilterOptimization {
    public TraversalControl visit(Exists target, OptimizationContext context) {
        ExpressionTerm term;
        List terms = target.getTerms();
        if (terms.size() == 1 && (RemoveExistsOnSingleValueProperties.isSingleValueOrScalarNode(term = (ExpressionTerm)terms.get(0)) && !RemoveExistsOnSingleValueProperties.isLiteralFilter(term, context) && !RemoveExistsOnSingleValueProperties.isInsideNegation(context.getParentContext()) || RemoveExistsOnSingleValueProperties.isNotExists(term))) {
            context.replaceCurrentWith((ExpressionValue)term);
        }
        return TraversalControl.CONTINUE;
    }

    private static boolean isSingleValueOrScalarNode(ExpressionTerm<?> term) {
        if (term instanceof Node) {
            Node node = (Node)term;
            return (node.getPropertyShape().isSingleValued() || node.getPropertyShape().isScalarType()) && !RemoveExistsOnSingleValueProperties.isLangName(node.getPropertyShape());
        }
        return false;
    }

    private static boolean isLangName(PropertyShape propertyShape) {
        return propertyShape.getName().equals("name") && propertyShape.getContainedIn().getContainedIn().isNameLiteral();
    }

    private static boolean isLiteralFilter(ExpressionTerm<?> term, OptimizationContext context) {
        if (term instanceof Node) {
            Node node = (Node)term;
            if (node.getPropertyShape().isLiteral()) {
                return true;
            }
            boolean isLiteral = "Literal".equals(node.getShape().getId());
            boolean isAtRootContext = context.getParentContext() == null;
            return isLiteral && isAtRootContext;
        }
        return false;
    }

    private static boolean isInsideNegation(OptimizationContext context) {
        if (context == null || context.getCurrentNode() == null) {
            return false;
        }
        if (context.getCurrentNode() instanceof Exists) {
            return false;
        }
        if (RemoveExistsOnSingleValueProperties.isNegation(context.getCurrentNode())) {
            return true;
        }
        return RemoveExistsOnSingleValueProperties.isInsideNegation(context.getParentContext());
    }

    private static boolean isNotExists(ExpressionTerm<?> term) {
        return RemoveExistsOnSingleValueProperties.isNegation(term) && RemoveExistsOnSingleValueProperties.allSubTermsAreExists((Expression)term);
    }

    private static boolean allSubTermsAreExists(Expression term) {
        return term.getTerms().stream().allMatch(Exists.class::isInstance);
    }

    private static boolean isNegation(ExpressionValue<?> value) {
        return value instanceof Not;
    }
}

