/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.AbstractFilterOptimization;
import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.graphql.parser.argument.optimization.UpperCaseRolesFilterValueOptimization;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.NotEquals;
import com.ontotext.models.query.TraversalControl;

public class FilterOperandValidator
extends AbstractFilterOptimization {
    public static final String NOT_COMPATIBLE_WITH_COLLECTION = " could not be used with collection";

    private boolean hasContextCollection(Object target) {
        String nodeValueAsString = target.toString();
        return UpperCaseRolesFilterValueOptimization.CTX_PATTERNS.stream().anyMatch(nodeValueAsString::contains);
    }

    public TraversalControl visit(Equals target, OptimizationContext context) {
        if (this.hasContextCollection(target)) {
            throw new IllegalArgumentException("EQ could not be used with collection");
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(NotEquals target, OptimizationContext context) {
        if (this.hasContextCollection(target)) {
            throw new IllegalArgumentException("NEQ could not be used with collection");
        }
        return TraversalControl.CONTINUE;
    }
}

