/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.graphql.parser.argument.optimization.SubQueryCreationOptimization;
import com.ontotext.models.OperationType;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.SelectDistinct;
import com.ontotext.models.query.TraversalControl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddSelectDistinct
extends SubQueryCreationOptimization {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddSelectDistinct.class);

    public AddSelectDistinct(StatisticsCollectorManager repoStatistics, List<OperationType> excludedOperations) {
        super(repoStatistics, excludedOperations);
    }

    public AddSelectDistinct(StatisticsCollectorManager repoStatistics) {
        super(repoStatistics);
    }

    public TraversalControl visit(And target, OptimizationContext context) {
        if (this.areWeInABranch(context)) {
            return TraversalControl.CONTINUE;
        }
        List exists = target.getTerms().stream().filter(Exists.class::isInstance).map(Exists.class::cast).collect(Collectors.toList());
        if (exists.size() < 2) {
            return TraversalControl.CONTINUE;
        }
        Exists replaceOffer = null;
        double replaceIdx = -1.0;
        for (Exists ex : exists) {
            double offerIdx = this.subQueryIndex(ex, context);
            if (!(offerIdx > replaceIdx)) continue;
            replaceIdx = offerIdx;
            replaceOffer = ex;
        }
        if (replaceOffer != null) {
            SelectDistinct selectDistinct = new SelectDistinct();
            selectDistinct.addTerm((ExpressionTerm)replaceOffer.getTerms().get(0));
            int idx = target.getTerms().indexOf(replaceOffer);
            target.getTerms().set(idx, selectDistinct);
            return TraversalControl.QUIT;
        }
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visit(Exists target, OptimizationContext context) {
        if (context.getParentNode() instanceof Not || context.getParentNode() instanceof Or) {
            return TraversalControl.CONTINUE;
        }
        if (this.areWeInABranch(context)) {
            return TraversalControl.CONTINUE;
        }
        if (this.subQueryIndex(target, context) > 0.0) {
            LOGGER.debug("Optimizing to SELECT DISTINCT the following expression: {}", (Object)target);
            SelectDistinct selectDistinct = new SelectDistinct();
            selectDistinct.addTerm((ExpressionTerm)target.getTerms().get(0));
            context.replaceCurrentWith((ExpressionValue)selectDistinct);
            return TraversalControl.QUIT;
        }
        return TraversalControl.CONTINUE;
    }
}

