/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument.optimization;

import com.ontotext.graphql.parser.argument.optimization.OptimizationContext;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollectorManager;
import com.ontotext.graphql.parser.argument.optimization.SubQueryCreationOptimization;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Minus;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.TraversalControl;

public class AddMinus
extends SubQueryCreationOptimization {
    public AddMinus(StatisticsCollectorManager repoStatistics) {
        super(repoStatistics);
    }

    public TraversalControl visit(Not target, OptimizationContext context) {
        if (this.areWeInABranch(context)) {
            return TraversalControl.CONTINUE;
        }
        if (target.getTerms().size() != 1) {
            return TraversalControl.CONTINUE;
        }
        if (this.areWeInExists(context)) {
            return TraversalControl.QUIT;
        }
        ExpressionTerm term = (ExpressionTerm)target.getTerms().get(0);
        if (term instanceof Exists) {
            if (this.isExistsId((Exists)term)) {
                return TraversalControl.CONTINUE;
            }
            if (this.subQueryIndex((Exists)term, context) > 0.0) {
                this.replaceWithMinus(context, (Exists)term);
                return TraversalControl.QUIT;
            }
        } else if (term instanceof Or) {
            Or or = (Or)term;
            if (or.getTerms().size() < 2) {
                return TraversalControl.CONTINUE;
            }
            Exists toReplace = this.findSuitableExistsForReplace(context, or);
            if (toReplace != null) {
                this.replaceExistsInOr(target, context, or, toReplace);
                return TraversalControl.QUIT;
            }
        }
        return TraversalControl.CONTINUE;
    }

    private void replaceWithMinus(OptimizationContext context, Exists term) {
        Minus minus = new Minus();
        term.getTerms().forEach(arg_0 -> ((Minus)minus).addTerm(arg_0));
        context.replaceCurrentWith((ExpressionValue)minus);
    }

    private Exists findSuitableExistsForReplace(OptimizationContext context, Or or) {
        Exists toReplace = null;
        for (ExpressionTerm subTerm : or.getTerms()) {
            if (!(subTerm instanceof Exists) || this.isExistsId((Exists)subTerm) || !(this.subQueryIndex((Exists)subTerm, context) > 0.0)) continue;
            toReplace = (Exists)subTerm;
            break;
        }
        return toReplace;
    }

    private void replaceExistsInOr(Not target, OptimizationContext context, Or or, Exists toReplace) {
        or.getTerms().remove(toReplace);
        ExpressionCollection collection = new ExpressionCollection();
        Minus minus = new Minus();
        toReplace.getTerms().forEach(arg_0 -> ((Minus)minus).addTerm(arg_0));
        collection.addTerm((ExpressionTerm)minus);
        if (or.getTerms().size() == 1) {
            target.getTerms().clear();
            target.addTerm((ExpressionTerm)or.getTerms().get(0));
        }
        collection.addTerm((ExpressionTerm)target);
        context.replaceCurrentWith((ExpressionValue)collection);
    }

    private boolean isExistsId(Exists exists) {
        return exists.getTerms().stream().anyMatch(term -> "id".equals(term.getName()));
    }

    private boolean areWeInExists(OptimizationContext context) {
        for (OptimizationContext parentContext = context.getParentContext(); parentContext != null; parentContext = parentContext.getParentContext()) {
            if (!(parentContext.getCurrentNode() instanceof Exists)) continue;
            return true;
        }
        return false;
    }
}

