/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ExpressionPreProcessor;
import com.ontotext.graphql.parser.argument.TypeFilterUtil;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeFilterPreProcessor
implements ExpressionPreProcessor {
    @Override
    public void preProcess(Map<String, Object> filters, Shape parentType) {
        SomlSchema schema = parentType.getContainedIn().getContainedIn();
        List<Object> typeFilters = filters.entrySet().stream().filter(entry -> TypeFilterUtil.isIfType((String)entry.getKey())).map(TypeFilterPreProcessor.toTypeFilterExpression(schema)).collect(Collectors.toList());
        if (typeFilters.isEmpty()) {
            return;
        }
        filters.keySet().removeIf(TypeFilterUtil::isIfType);
        TypeFilterUtil.mergeChanges(filters, typeFilters);
    }

    private static Function<Map.Entry<String, Object>, Map<String, Object>> toTypeFilterExpression(SomlSchema schema) {
        return entry -> {
            Prefixes prefixes = schema.getPrefixes();
            String type = ((String)entry.getKey()).replace("_if", "");
            Shape expectedType = (Shape)schema.getObjects().get((Object)prefixes.nameToShortIri(type));
            Map<String, Object> typeConstraints = TypeFilterPreProcessor.buildTypeConstraints(expectedType);
            LinkedHashMap<String, Object> typedFilter = new LinkedHashMap<String, Object>();
            if (entry.getValue() instanceof Map) {
                if (((Map)entry.getValue()).isEmpty()) {
                    typedFilter.putAll(typeConstraints);
                } else {
                    typedFilter.put("AND", Arrays.asList(typeConstraints, entry.getValue()));
                }
            } else {
                throw new IllegalArgumentException("Unexpected filter entry type: " + String.valueOf(entry.getValue()));
            }
            typedFilter.put("%typeOverride%", expectedType);
            return typedFilter;
        };
    }

    private static Map<String, Object> buildTypeConstraints(Shape expectedType) {
        ArrayList<Map<String, Object>> constraints = new ArrayList<Map<String, Object>>();
        TypeFilterPreProcessor.buildTypeConstraints(expectedType, constraints, new LinkedHashSet<String>());
        if (constraints.isEmpty()) {
            return Collections.emptyMap();
        }
        if (constraints.size() == 1) {
            return (Map)constraints.get(0);
        }
        return Collections.singletonMap("AND", constraints);
    }

    private static void buildTypeConstraints(Shape expectedType, List<Map<String, Object>> constraints, Set<String> processedTypeProps) {
        if (!processedTypeProps.contains(expectedType.getTypePropIri())) {
            processedTypeProps.add(expectedType.getTypePropIri());
            Map<String, Object> constraint = TypeFilterPreProcessor.buildSingleTypeConstraint(expectedType);
            if (!constraint.isEmpty()) {
                constraints.add(constraint);
            }
        }
        for (String parentId : expectedType.getInheritsAsList()) {
            Shape parent = (Shape)expectedType.getContainedIn().getContainedIn().getObjects().get((Object)parentId);
            TypeFilterPreProcessor.buildTypeConstraints(parent, constraints, processedTypeProps);
        }
    }

    private static Map<String, Object> buildSingleTypeConstraint(Shape expectedType) {
        List typeAsList = expectedType.getTypeAsList();
        Map<String, Object> typeRestriction = null;
        if (typeAsList.size() == 1) {
            typeRestriction = Collections.singletonMap("EQ", (String)typeAsList.get(0));
        } else if (!typeAsList.isEmpty()) {
            typeRestriction = Collections.singletonMap("IN", typeAsList);
        }
        if (typeRestriction == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> restriction = typeRestriction;
        if (!TypeFilterPreProcessor.hasScalarTypeProp(expectedType)) {
            restriction = Collections.singletonMap("id", typeRestriction);
        }
        return Collections.singletonMap(TypeFilterPreProcessor.resolveTypePropName(expectedType), restriction);
    }

    private static boolean hasScalarTypeProp(Shape expectedType) {
        String typeProp = expectedType.getTypeProp();
        if (typeProp.equals("rdf:type")) {
            return true;
        }
        Optional property = expectedType.getProperty(typeProp);
        return property.map(PropertyShape::isScalarType).orElse(true);
    }

    private static String resolveTypePropName(Shape expectedType) {
        String typeProp = expectedType.getTypeProp();
        if (typeProp.equals("rdf:type")) {
            return "type";
        }
        Prefixes prefixes = expectedType.getContainedIn().getContainedIn().getPrefixes();
        return expectedType.getProperty(typeProp).map(PropertyShape::getName).map(arg_0 -> ((Prefixes)prefixes).toName(arg_0)).orElse(prefixes.toName(typeProp));
    }
}

