/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ExpressionPreProcessor;
import com.ontotext.graphql.parser.argument.TypeFilterUtil;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.ExpressionsFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeFilterGeneratorPreProcessor
implements ExpressionPreProcessor {
    private static final String ALREADY_PROCESSED = "%alreadyProcessed%";
    private static final Set<String> ID = new HashSet<String>(Arrays.asList("id", "ID"));

    @Override
    public void preProcess(Map<String, Object> filters, Shape parentType) {
        if (filters.containsKey(ALREADY_PROCESSED)) {
            filters.remove(ALREADY_PROCESSED);
            return;
        }
        if (!parentType.isAbstract()) {
            return;
        }
        SomlSchema schema = parentType.getContainedIn().getContainedIn();
        Set overriddenProperties = filters.keySet().stream().filter(key -> !TypeFilterUtil.isIfType(key)).filter(ExpressionsFactory::isNode).filter(key -> this.isRdfPropDifferentInSubTypes((String)key, parentType, schema)).collect(Collectors.toSet());
        Set<String> subTypesInDifferentService = parentType.getSubTypes().stream().filter(subType -> !Objects.equals(parentType.getServiceAddress(), subType.getServiceAddress())).map(Shape::getId).collect(Collectors.toSet());
        if (overriddenProperties.isEmpty() && subTypesInDifferentService.isEmpty()) {
            return;
        }
        List<Object> typeFilters = filters.entrySet().stream().filter(entry -> overriddenProperties.contains(entry.getKey()) || this.shouldBeRanInDifferentService(subTypesInDifferentService, (Map.Entry<String, Object>)entry)).map(TypeFilterGeneratorPreProcessor.toTypeFilterExpression(parentType, schema, subTypesInDifferentService)).collect(Collectors.toList());
        if (typeFilters.isEmpty()) {
            return;
        }
        if (!subTypesInDifferentService.isEmpty()) {
            filters.keySet().removeIf(key -> !ID.contains(key));
        } else {
            filters.keySet().removeIf(overriddenProperties::contains);
        }
        TypeFilterUtil.mergeChanges(filters, typeFilters);
    }

    private boolean shouldBeRanInDifferentService(Set<String> subTypesInDifferentService, Map.Entry<String, Object> entry) {
        return !subTypesInDifferentService.isEmpty() && !ID.contains(entry.getKey());
    }

    private boolean isRdfPropDifferentInSubTypes(String propertyName, Shape parentType, SomlSchema schema) {
        String modelPropertyName = schema.getPrefixes().toModelShortIri(propertyName);
        return !parentType.getPropertyRepresentationInSubTypes(modelPropertyName).isEmpty();
    }

    private static Function<Map.Entry<String, Object>, Map<String, Object>> toTypeFilterExpression(Shape parentType, SomlSchema schema, Set<String> subTypesInDifferentService) {
        int parentSubTypesSize = parentType.getSubTypes().size();
        return entry -> {
            Prefixes prefixes = schema.getPrefixes();
            String modelPropertyName = prefixes.toModelShortIri((String)entry.getKey());
            Map overriddenProperties = parentType.getPropertyRepresentationInSubTypes(modelPropertyName);
            for (String federatedSubtype : subTypesInDifferentService) {
                if (overriddenProperties.containsKey(federatedSubtype)) continue;
                overriddenProperties.put(federatedSubtype, parentType.getPropertyOrFail(modelPropertyName));
            }
            List overrides = overriddenProperties.keySet().stream().map(shapeId -> TypeFilterUtil.toIfType(prefixes.toName(shapeId))).map(shapeId -> TypeFilterGeneratorPreProcessor.asMap(shapeId, TypeFilterGeneratorPreProcessor.asMap((String)entry.getKey(), entry.getValue(), true), true)).collect(Collectors.toList());
            if (parentSubTypesSize != overrides.size()) {
                overrides.add(TypeFilterGeneratorPreProcessor.asMap((String)entry.getKey(), entry.getValue(), true));
            }
            return TypeFilterGeneratorPreProcessor.asMap("OR", overrides, false);
        };
    }

    private static Map<String, Object> asMap(String key, Object value, boolean processed) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        map.put(key, value);
        if (processed) {
            map.put(ALREADY_PROCESSED, Collections.emptyMap());
        }
        return map;
    }
}

