/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.WhereArgumentParser;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.SchemaLangConfig;
import com.ontotext.models.Shape;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.LangFilter;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LangFilterArgumentParser
extends WhereArgumentParser {
    private static final SchemaLangConfig EMPTY = new SchemaLangConfig();

    public LangFilterArgumentParser(InputValueConverter valueConverter) {
        super(valueConverter);
    }

    @Override
    public Object parseArgument(Object value, ArgumentParserContext parserContext) {
        if (value instanceof String && this.isLangFilterApplicable(parserContext)) {
            LangFilter langFilter;
            if (!parserContext.getPropertyShape().filter(PropertyShape::isLiteral).isPresent() && this.isNotName(parserContext)) {
                return value;
            }
            String langPattern = LangFilter.applyUserLanguages((String)value.toString(), (String)parserContext.getVariables().getAcceptLanguage());
            HashMap<String, LangFilter> map = new HashMap<String, LangFilter>();
            if (parserContext.getOperationType() == OperationType.QUERY) {
                langFilter = LangFilter.parseForFetching((String)langPattern);
                if ("name".equals(parserContext.getFieldName())) {
                    langFilter = this.appendDefaultNameLangFilters(langFilter, parserContext);
                    parserContext = this.createLiteralParserContext(parserContext);
                }
            } else {
                langFilter = LangFilter.parseForFilter((String)langPattern);
            }
            map.put("lang", langFilter);
            ExpressionValue expression = (ExpressionValue)super.parseArgument(map, parserContext);
            langFilter.setExpression(expression);
            return langFilter;
        }
        if (value instanceof Map || value instanceof Collection) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", value);
            return super.parseArgument(map, parserContext);
        }
        return null;
    }

    private ArgumentParserContext createLiteralParserContext(ArgumentParserContext parserContext) {
        Shape literalShape = (Shape)parserContext.getContainingType().getContainedIn().getContainedIn().getObjects().get((Object)"Literal");
        return parserContext.changeTypeTo(literalShape);
    }

    private boolean isLangFilterApplicable(ArgumentParserContext parserContext) {
        if (this.isNotName(parserContext)) {
            return true;
        }
        Optional<PropertyShape> propertyShape = parserContext.getPropertyShape();
        if (!propertyShape.isPresent()) {
            return true;
        }
        Shape shape = propertyShape.get().getContainedIn().getContainedIn();
        if (SparqlUtil.isSparqlTemplate((String)shape.getNameIri())) {
            return true;
        }
        Optional realNameShape = shape.getProperty(shape.getNameIri());
        return realNameShape.filter(property -> property.getScalarType().isLangStringSupported()).isPresent();
    }

    private boolean isNotName(ArgumentParserContext parserContext) {
        return !parserContext.getFieldName().equals("name");
    }

    private LangFilter appendDefaultNameLangFilters(LangFilter filter, ArgumentParserContext parserContext) {
        SchemaLangConfig schemaLangConfig = parserContext.getContainingType().getContainedIn().getContainedIn().getConfig().getLang().orElse(EMPTY);
        if (filter.toString().equals("ALL")) {
            if (schemaLangConfig.hasDefaultNameFetch()) {
                return LangFilter.parseForFetching((String)schemaLangConfig.getDefaultNameFetch());
            }
            return LangFilter.parseForFetching((String)"ANY");
        }
        boolean appendDefaultNamePattern = schemaLangConfig.hasDefaultNameFetch() && schemaLangConfig.isAppendDefaultNameFetch();
        Stream stream = appendDefaultNamePattern ? Stream.concat(filter.getTokens().stream(), LangFilter.parseForFetching((String)schemaLangConfig.getDefaultNameFetch()).getTokens().stream()) : filter.getTokens().stream();
        List tokens = stream.filter(token -> token.getType() != LangFilter.TokenType.ALL).distinct().collect(Collectors.toList());
        return LangFilter.parseForFetching((String)LangFilter.Token.toString(tokens));
    }

    @Override
    public void register(ArgumentConverter argumentConverter) {
        argumentConverter.registerArgumentParser("lang", this);
        argumentConverter.registerArgumentParser("value", this);
    }
}

