/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.query.SourceLocation;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ErrorReporting {
    private final Map<String, Object> metadata;
    private final List<GraphQLError> errors;
    private final String property;

    ErrorReporting() {
        this(null, new ArrayList<GraphQLError>(), null);
    }

    private ErrorReporting(Map<String, Object> metadata) {
        this(metadata, new ArrayList<GraphQLError>(), null);
    }

    private ErrorReporting(Map<String, Object> metadata, List<GraphQLError> errors, String property) {
        this.metadata = metadata;
        this.errors = errors;
        this.property = property;
    }

    ErrorReporting newRootReporter(Map<String, Object> metadata) {
        if (this.errors == null) {
            return new ErrorReporting(metadata);
        }
        return new ErrorReporting(metadata, this.errors, null);
    }

    ErrorReporting stepIn(String property) {
        return this.stepInInternal(property, property);
    }

    ErrorReporting stepIn(int idx) {
        return this.stepInInternal(String.valueOf(idx), this.property);
    }

    private ErrorReporting stepInInternal(String property, String parentProperty) {
        Object val = this.metadata.get(property);
        if (val instanceof Map) {
            return new ErrorReporting((Map)val, this.errors, parentProperty);
        }
        return new ErrorReporting(Collections.emptyMap(), this.errors, parentProperty);
    }

    InvalidOperationException createError(String message) {
        return new InvalidOperationException("Query parsing error", Collections.singletonList(this.createGqlError(message)));
    }

    private SimpleGraphQlError createGqlError(String message) {
        SourceLocation sl = this.getLocation();
        if (sl == null) {
            return new SimpleGraphQlError(message, null, (ErrorClassification)ErrorType.ValidationError);
        }
        return new SimpleGraphQlError(message, Collections.singletonList(new graphql.language.SourceLocation(sl.getLine(), sl.getColumn())), (ErrorClassification)ErrorType.ValidationError);
    }

    void addError(String message) {
        this.errors.add(this.createGqlError(message));
    }

    void addErrorMessage(String template, Object ... args) {
        this.addError(ErrorMessages.get((String)template, (Object[])args));
    }

    SourceLocation getLocation() {
        return (SourceLocation)this.metadata.get("sourceLocation");
    }

    List<SourceLocation> getLocationAsList() {
        SourceLocation location = this.getLocation();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(location);
    }

    void report() {
        if (!this.errors.isEmpty()) {
            throw new InvalidOperationException("Query parsing error", this.errors);
        }
    }

    boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    String getProperty() {
        return this.property;
    }
}

