/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.ErrorReporting;
import com.ontotext.graphql.parser.argument.LiteralValueHandler;
import com.ontotext.models.OperationType;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class CreateMutationArgumentParser {
    private final InputValueConverter valueConverter;
    private final ArgumentParserContext parserContext;
    private final SomlSchema schema;
    private final Prefixes prefixes;
    private final LiteralValueHandler literalHandler;

    public CreateMutationArgumentParser(InputValueConverter valueConverter, ArgumentParserContext parserContext) {
        this.valueConverter = valueConverter;
        this.parserContext = parserContext;
        this.schema = parserContext.getContainingType().getContainedIn().getContainedIn();
        this.prefixes = this.schema.getPrefixes();
        this.literalHandler = new LiteralValueHandler(this.schema, parserContext);
        if (parserContext.getOperationType() != OperationType.CREATE) {
            throw new IllegalArgumentException("Passed none CREATE operation. Cannot process " + String.valueOf(parserContext.getOperationType()) + " operations.");
        }
    }

    List<Change> readMutationCreate(List<Map<String, Object>> mutationProps, List<Map<String, Object>> metadata) {
        LinkedHashMap<String, Change> changes = new LinkedHashMap<String, Change>();
        Shape type = this.parserContext.getContainingType();
        ErrorReporting reporter = new ErrorReporting();
        for (int i = 0; i < mutationProps.size(); ++i) {
            Map<String, Object> propertiesMap = mutationProps.get(i);
            Map<String, Object> objectMetadata = metadata.isEmpty() ? Collections.emptyMap() : metadata.get(i);
            ErrorReporting errorReporting = reporter.newRootReporter(objectMetadata);
            String id = Objects.toString(propertiesMap.remove("id"), ReferenceId.randomId());
            Change change = changes.computeIfAbsent(id, this.createChange(type, errorReporting.getLocation()));
            this.readMutationProperties(errorReporting, changes, change, propertiesMap, type);
        }
        reporter.report();
        return this.buildResult(changes);
    }

    private List<Change> buildResult(Map<String, Change> changes) {
        ArrayList<Change> resultChanges = new ArrayList<Change>(changes.values());
        this.parserContext.getArguments().getGraph().ifPresent(graph -> resultChanges.forEach(change -> change.setGraph(graph)));
        return resultChanges;
    }

    private void readMutationProperties(ErrorReporting errorReporting, Map<String, Change> changes, Change change, Map<String, Object> argValues, Shape type) {
        for (Map.Entry<String, Object> singleValue : argValues.entrySet()) {
            String argumentName = singleValue.getKey();
            Object convertedValue = singleValue.getValue();
            Optional property = type.getProperty(this.prefixes.nameToShortIri(argumentName));
            ErrorReporting reporting = errorReporting.stepIn(argumentName);
            if (property.filter(PropertyShape::isScalarType).isPresent()) {
                this.addPropertyChange(change, argumentName, convertedValue, reporting);
                continue;
            }
            if (this.isNestedMutation(convertedValue)) {
                List<Object> idList = new ArrayList();
                if (convertedValue instanceof Map) {
                    idList = this.addNestedChange(argumentName, reporting, changes, change, (Map)convertedValue);
                } else {
                    List values = (List)convertedValue;
                    for (int i = 0; i < values.size(); ++i) {
                        Map nestedObject = (Map)values.get(i);
                        ErrorReporting nextReporting = reporting.stepIn(i);
                        idList.addAll(this.addNestedChange(argumentName, nextReporting, changes, change, nestedObject));
                    }
                }
                idList.forEach(id -> this.addPropertyChange(change, argumentName, id, reporting));
                continue;
            }
            throw new IllegalArgumentException("Unknown property " + argumentName);
        }
    }

    private boolean isNestedMutation(Object mutationValue) {
        return mutationValue instanceof List && !((List)mutationValue).isEmpty() && ((List)mutationValue).get(0) instanceof Map || mutationValue instanceof Map;
    }

    private List<String> addNestedChange(String propertyName, ErrorReporting errorReporting, Map<String, Change> changes, Change change, Map<String, Object> nestedObjectMap) {
        Object where;
        ArrayList<String> idList = new ArrayList<String>();
        Object ids = nestedObjectMap.remove("ids");
        if (ids != null) {
            if (ids instanceof Collection) {
                idList.addAll((Collection)ids);
            } else if (ids instanceof String) {
                idList.add((String)ids);
            }
        }
        if ((where = nestedObjectMap.remove("where")) != null) {
            this.parseNestedFilter(propertyName, change, where, errorReporting);
        }
        for (Map.Entry<String, Object> nestedOfType : nestedObjectMap.entrySet()) {
            String type = this.prefixes.nameToShortIri(nestedOfType.getKey());
            if (!type.contains(":")) {
                type = StringUtils.capitalize((String)type);
            }
            ErrorReporting reporting = errorReporting.stepIn(nestedOfType.getKey());
            if (nestedOfType.getValue() instanceof List) {
                int idx = 0;
                for (Object nestedObject : (List)nestedOfType.getValue()) {
                    int n = idx++;
                    this.parseNestedObject(reporting.stepIn(n), changes, change, type, propertyName, (Map)nestedObject).ifPresent(idList::add);
                }
                continue;
            }
            this.parseNestedObject(reporting, changes, change, type, propertyName, (Map)nestedOfType.getValue()).ifPresent(idList::add);
        }
        return idList;
    }

    private Optional<String> parseNestedObject(ErrorReporting errorReporting, Map<String, Change> changes, Change change, String type, String propertyName, Map<String, Object> propertyMap) {
        Shape nestedShape = (Shape)this.schema.getObjects().get((Object)type);
        String id = ObjectsUtil.getOrDefaultGet((Object)propertyMap.remove("id"), ReferenceId::randomId).toString();
        if (changes.containsKey(id)) {
            errorReporting.addErrorMessage("mutation.create.duplicateId", id);
            return Optional.empty();
        }
        PropertyShape property = change.getShape().getPropertyOrFail(this.prefixes.nameToShortIri(propertyName));
        Change nestedChange = changes.computeIfAbsent(id, this.createChange(nestedShape, errorReporting.getLocation()));
        nestedChange.setPreconditions(new ChangePreconditions(change, property, null, null));
        this.readMutationProperties(errorReporting, changes, nestedChange, propertyMap, nestedShape);
        return Optional.of(id);
    }

    private void parseNestedFilter(String argName, Change change, Object where, ErrorReporting errorReporting) {
        Optional propShape = change.getShape().getProperty(argName);
        if (!propShape.isPresent()) {
            errorReporting.addErrorMessage("mutation.nonFilterableProperty", argName, change.getShape().getId());
            return;
        }
        Shape nestedShape = (Shape)change.getShape().getContainedIn().get((Object)((PropertyShape)propShape.get()).getRange());
        List types = nestedShape.isAbstract() || nestedShape.isUnion() ? nestedShape.getConcreteSubTypes().stream().flatMap(shape -> shape.getTypeAsList().stream()).collect(Collectors.toList()) : nestedShape.getTypeAsList();
        Map typenameFilter = Collections.singletonMap("type", Collections.singletonMap("IN", types));
        Map typedFilter = Collections.singletonMap("AND", Stream.of(typenameFilter, where).collect(Collectors.toList()));
        change.addObjectFilter(argName, (ExpressionValue)this.parserContext.parseNestedArgument(nestedShape, "where", typedFilter));
    }

    private void addPropertyChange(Change change, String name, Object convertedValue, ErrorReporting errorReporting) {
        Optional<PropertyChange> extantChange = change.getChanges().stream().filter(propChange -> propChange.getName().equals(name)).findFirst();
        PropertyShape propertyShape = change.getPropertyChangeShape(name);
        convertedValue = this.checkForLiteralValues(convertedValue, propertyShape, errorReporting);
        if (extantChange.isPresent()) {
            if (propertyShape.isScalarType()) {
                errorReporting.addErrorMessage("mutation.create.duplicateProperty", change.getId());
                return;
            }
            if (propertyShape.isMultivalued()) {
                change.mergePropertyValue(extantChange.get().getName(), convertedValue, errorReporting.getLocation());
            } else {
                change.replacePropertyValue(extantChange.get().getName(), convertedValue, errorReporting.getLocationAsList());
            }
        } else {
            change.addPropertyValue(name, convertedValue, errorReporting.getLocationAsList());
        }
    }

    private Object checkForLiteralValues(Object value, PropertyShape property, ErrorReporting errorReporting) {
        if (value instanceof Map) {
            return this.literalHandler.addLangValueSupportDuringCreate(Collections.singletonList((Map)value), property, errorReporting).get(0);
        }
        if (value instanceof Collection) {
            ArrayList<Map<String, Object>> updatedValues = new ArrayList<Map<String, Object>>(((Collection)value).size());
            for (Object subValue : (Collection)value) {
                if (!(subValue instanceof Map)) continue;
                updatedValues.add((Map)subValue);
            }
            if (!updatedValues.isEmpty()) {
                return this.literalHandler.addLangValueSupportDuringCreate(updatedValues, property, errorReporting);
            }
        }
        return value;
    }

    private Function<String, Change> createChange(Shape type, SourceLocation location) {
        return changeId -> new Change(changeId, OperationType.CREATE, type, location, this.valueConverter);
    }
}

