/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser.argument;

import com.ontotext.graphql.parser.argument.ArgumentParser;
import com.ontotext.graphql.parser.argument.ArgumentParserContext;
import com.ontotext.graphql.parser.argument.PassThroughArgumentParser;
import com.ontotext.models.query.InputValueConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ArgumentConverter {
    private Map<String, ArgumentParser> argumentParserMap = new HashMap<String, ArgumentParser>();
    private ArgumentParser defaultParser = PassThroughArgumentParser.INSTANCE;
    private final InputValueConverter valueConverter;

    public ArgumentConverter(InputValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public Object convert(String name, Object value, ArgumentParserContext parserContext) {
        ArgumentParser argumentParser = this.argumentParserMap.getOrDefault(name, this.defaultParser);
        return argumentParser.parseArgument(value, parserContext);
    }

    public void registerArgumentParser(String name, ArgumentParser argumentParser) {
        Objects.requireNonNull(name, "Cannot register parser to null argument name");
        Objects.requireNonNull(argumentParser, "Cannot register null parser to argument name: " + name);
        this.argumentParserMap.put(name, argumentParser);
    }

    public void setDefaultParser(ArgumentParser defaultParser) {
        if (defaultParser != null) {
            this.defaultParser = defaultParser;
        }
    }

    public InputValueConverter getValueConverter() {
        return this.valueConverter;
    }
}

