/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.ArgumentCollector;
import com.ontotext.graphql.parser.ArgumentReader;
import com.ontotext.graphql.parser.QueryTraversalControl;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.BaseOperation;
import com.ontotext.models.InfoOperation;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.Variables;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.connection.EndpointBuilder;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.Scalars;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.SourceLocation;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class QueryTraversal {
    private static final String CREATE_PREFIX = "create";
    private static final String UPDATE_PREFIX = "update";
    private static final String DELETE_PREFIX = "delete";
    private static final Map<String, Supplier<Mutation>> MUTATION_FACTORY = new HashMap<String, Supplier<Mutation>>();
    private final QueryTraversalControl control;
    private final Map<String, FragmentDefinition> fragments;
    private final Deque<String> path = new LinkedList<String>();
    private final ArgumentReader argumentReader;
    private final EndpointBuilder endpointBuilder;
    private List<GraphQLError> graphQlErrors = new LinkedList<GraphQLError>();
    private final Variables variables;
    private Function<String, Mutation> mutationBuilder;
    private final SecurityContext securityContext;

    QueryTraversal(QueryTraversalControl control, Variables variables, Map<String, FragmentDefinition> fragments, List<VariableDefinition> variableDefinitions, EndpointBuilder endpointBuilder, Function<String, Mutation> mutationBuilder, SecurityContext securityContext) {
        this.control = control;
        this.fragments = fragments;
        this.variables = variables == null ? new Variables() : variables;
        this.argumentReader = control.createArgumentParser(this.variables);
        this.endpointBuilder = endpointBuilder;
        this.mutationBuilder = mutationBuilder;
        this.securityContext = securityContext;
        this.setDefaultVariableValues(variableDefinitions);
    }

    private void setDefaultVariableValues(List<VariableDefinition> variableDefinitions) {
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            Value defaultValue = variableDefinition.getDefaultValue();
            if (defaultValue == null) continue;
            ArgumentCollector argumentCollector = new ArgumentCollector((Map<String, Object>)this.variables);
            defaultValue.accept(null, (NodeVisitor)argumentCollector);
            Object value = argumentCollector.getValue();
            if (value == null) continue;
            defaultValues.put(variableDefinition.getName(), value);
        }
        if (!defaultValues.isEmpty()) {
            this.variables.setDefaultValues(defaultValues);
        }
    }

    Operation traverse(OperationDefinition.Operation operation, Field queryDefinition) {
        Operation result;
        this.graphQlErrors.clear();
        if (queryDefinition.getName().equals("__typename")) {
            result = this.readAsInfo(operation, queryDefinition);
        } else {
            switch (operation) {
                case QUERY: {
                    if (queryDefinition.getName().endsWith("_subscription")) {
                        result = this.readAsSubscriptionQuery(queryDefinition);
                        break;
                    }
                    result = this.readAsQuery(queryDefinition, (BaseOperation)new Query());
                    break;
                }
                case MUTATION: {
                    result = this.readAsMutation(queryDefinition);
                    break;
                }
                case SUBSCRIPTION: {
                    result = this.readAsSubscriptionQuery(queryDefinition);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.name());
                }
            }
        }
        if (!this.graphQlErrors.isEmpty()) {
            throw new InvalidOperationException("Failed operation parsing", this.graphQlErrors);
        }
        return result;
    }

    private Operation readAsInfo(OperationDefinition.Operation operation, Field queryDefinition) {
        return new InfoOperation(StringUtils.capitalize((String)operation.toString().toLowerCase()), queryDefinition.getAlias(), this.control.getSomlSchema());
    }

    private Operation readAsMutation(Field mutationDefinition) {
        this.checkIfMutationsAreAllowed(mutationDefinition);
        Mutation mutation = this.createMutationInstance(mutationDefinition);
        mutation.setName(mutationDefinition.getName());
        mutation.setAlias(mutationDefinition.getAlias());
        mutation.setVariables(this.variables);
        GraphQLSchemaElement mutationResponseType = this.getMutationResponseType(mutationDefinition);
        mutation.setReturnType(QueryTraversal.getTypeName(mutationResponseType));
        mutation.setReturnTypeInstance(this.control.getObject(mutation.getReturnType()));
        mutation.setReturnTypeAsList(QueryTraversal.isMultiValue((GraphQLSchemaElement)this.control.getGraphQlSchema().getMutationType().getFieldDefinition(mutationDefinition.getName()).getType()));
        this.path.clear();
        this.path.add(mutation.getName());
        GraphQLSchemaElement mutationObjectType = this.getMutationParentType(mutationDefinition);
        mutation.setResponseType(QueryTraversal.getTypeName(mutationObjectType));
        Shape responseTypeInstance = this.control.getObject(mutation.getResponseType());
        mutation.setResponseTypeInstance(responseTypeInstance);
        Arguments arguments = this.getReadArguments(mutationDefinition, responseTypeInstance, mutation.getOperationType());
        mutation.setArguments(arguments);
        mutation.setSelections(this.readSelectionSet(mutationDefinition.getSelectionSet(), mutationResponseType));
        mutation.setLocation(this.copySourceLocation((AbstractNode<?>)mutationDefinition));
        if (mutation.getOperationType() == OperationType.DELETE) {
            Argument whereArg = mutationDefinition.getArguments().stream().filter(argument -> argument.getName().equals("where")).findFirst().orElseThrow(() -> new GraphQLException("Cannot find source where argument for deletion."));
            this.setDeleteChanges(arguments, responseTypeInstance, this.copySourceLocation((AbstractNode<?>)whereArg));
        }
        this.control.postProcess((Operation)mutation, this.securityContext);
        return mutation;
    }

    private void checkIfMutationsAreAllowed(Field mutationDefinition) {
        GraphQLObjectType mutationType = this.control.getGraphQlSchema().getMutationType();
        if (mutationType == null) {
            throw new InvalidOperationException("Query parsing error", Collections.singletonList(new SimpleGraphQlError(String.format("Mutations are not allowed @ '%s'", mutationDefinition.getName()), Collections.singletonList(mutationDefinition.getSourceLocation()), (ErrorClassification)ErrorType.OperationNotSupported)));
        }
    }

    private void setDeleteChanges(Arguments arguments, Shape shape, com.ontotext.models.query.SourceLocation location) {
        InputValueConverter valueConverter = this.control.getInputValueConverter();
        List entitiesToDelete = arguments.resolveId().stream().distinct().map(id -> new Change(id, OperationType.DELETE, shape, location, valueConverter)).collect(Collectors.toList());
        arguments.setChanges(entitiesToDelete);
    }

    private Mutation createMutationInstance(Field mutationDefinition) {
        String mutationName = mutationDefinition.getName();
        String strippedFromPfx = this.getMutationNameStrippedOfPfx(mutationName);
        String[] split = strippedFromPfx.split("_", 2);
        if (split.length != 2) {
            Mutation mutation = null;
            if (this.mutationBuilder != null) {
                mutation = this.mutationBuilder.apply(strippedFromPfx);
            }
            if (mutation == null) {
                throw new IllegalArgumentException("Invalid mutation name: " + mutationDefinition.getName());
            }
            return mutation;
        }
        Supplier<Mutation> mutationSupplier = MUTATION_FACTORY.get(split[0]);
        if (mutationSupplier == null) {
            Mutation mutation = null;
            if (this.mutationBuilder != null) {
                mutation = this.mutationBuilder.apply(strippedFromPfx);
            }
            if (mutation == null) {
                throw new IllegalArgumentException("Invalid mutation name: " + mutationDefinition.getName());
            }
            return mutation;
        }
        return mutationSupplier.get();
    }

    private Operation readAsQuery(Field queryDefinition, BaseOperation operation) {
        GraphQLSchemaElement queryReturnType = this.getQueryActualType(queryDefinition);
        operation.setName(queryDefinition.getName());
        operation.setAlias(queryDefinition.getAlias());
        operation.setReturnType(QueryTraversal.getTypeName(queryReturnType));
        operation.setReturnTypeInstance(this.resolveQueryReturnType(operation));
        operation.setSchema(this.control.getSomlSchema());
        operation.setVariables(this.variables);
        operation.setReturnTypeAsList(QueryTraversal.isMultiValue((GraphQLSchemaElement)this.control.getGraphQlSchema().getQueryType().getFieldDefinition(queryDefinition.getName()).getType()));
        this.path.clear();
        this.path.add(operation.getResponseName());
        operation.setArguments(this.getReadArguments(queryDefinition, operation.getReturnTypeInstance(), operation.getOperationType()));
        operation.setSelections(this.readSelectionSet(queryDefinition.getSelectionSet(), queryReturnType));
        operation.setLocation(this.copySourceLocation((AbstractNode<?>)queryDefinition));
        this.setSelectionTypeInstances(operation.getSelections());
        this.control.postProcess((Operation)operation, this.securityContext);
        return operation;
    }

    private Shape resolveQueryReturnType(BaseOperation operation) {
        String name;
        Shape object;
        Shape shape = this.control.getObject(operation.getReturnType());
        if (shape.asGraphQl().equals(operation.getReturnType())) {
            return shape;
        }
        int index = operation.getName().lastIndexOf(95);
        if (index > 0 && !(object = this.control.getObject(name = StringUtils.capitalize((String)operation.getName().substring(0, index)))).getId().equals("Object")) {
            return object;
        }
        return shape;
    }

    private Operation readAsSubscriptionQuery(Field queryDefinition) {
        return this.readAsQuery(queryDefinition, (BaseOperation)new Subscription());
    }

    private void setSelectionTypeInstances(List<Selection> selections) {
        for (Selection selection : selections) {
            if (selection.getDefinedInType() == null) continue;
            selection.setDefinedInType(this.control.getObject(selection.getDefinedInType().getId()));
            if (selection.getSelections() == null) continue;
            this.setSelectionTypeInstances(selection.getSelections());
        }
    }

    private List<Selection> readSelectionSet(SelectionSet selectionSet, GraphQLSchemaElement gqlType) {
        if (selectionSet == null) {
            return Collections.emptyList();
        }
        Function<String, GraphQLSchemaElement> typeResolver = QueryTraversal.resolveType(gqlType);
        String typeName = QueryTraversal.getTypeName(gqlType);
        return selectionSet.getSelections().stream().flatMap(sel -> this.handleSelection((graphql.language.Selection<?>)sel, typeResolver, typeName)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private Stream<Selection> handleSelection(graphql.language.Selection<?> selection, Function<String, GraphQLSchemaElement> typeResolver, String parentType) {
        if (selection instanceof Field) {
            return Stream.of(this.readField((Field)selection, typeResolver, parentType));
        }
        if (selection instanceof InlineFragment || selection instanceof FragmentSpread) {
            return this.readFragment(selection, parentType);
        }
        return Stream.empty();
    }

    private Stream<Selection> readFragment(graphql.language.Selection<?> selection, String parentType) {
        InlineFragment container;
        String referencedType;
        if (selection instanceof InlineFragment) {
            InlineFragment inlineFragment = (InlineFragment)selection;
            referencedType = inlineFragment.getTypeCondition().getName();
            container = inlineFragment;
        } else if (selection instanceof FragmentSpread) {
            FragmentDefinition fragmentDefinition = this.fragments.get(((FragmentSpread)selection).getName());
            referencedType = fragmentDefinition.getTypeCondition().getName();
            container = fragmentDefinition;
        } else {
            return Stream.empty();
        }
        String actualType = this.getMostRestrictiveType(referencedType, parentType);
        GraphQLType graphQlType = this.control.getGraphQlSchema().getType(actualType);
        Function<String, GraphQLSchemaElement> referencedTypeResolver = QueryTraversal.resolveType((GraphQLSchemaElement)graphQlType);
        return container.getSelectionSet().getSelections().stream().flatMap(fragmentSelection -> this.handleSelection((graphql.language.Selection<?>)fragmentSelection, referencedTypeResolver, actualType));
    }

    private String getMostRestrictiveType(String parent, String child) {
        Shape shape = (Shape)this.control.getSomlSchema().getObjects().get((Object)child);
        if (shape != null) {
            if (shape.isUnion()) {
                return parent;
            }
            if (shape.isSubClassOf(parent)) {
                return child;
            }
        }
        return parent;
    }

    private Selection readField(Field field, Function<String, GraphQLSchemaElement> gqlTypeResolver, String parentType) {
        Selection selection = new Selection();
        String name = field.getName();
        selection.setName(name);
        selection.setAlias(field.getAlias());
        GraphQLSchemaElement gqlType = gqlTypeResolver.apply(name);
        selection.setType(QueryTraversal.getTypeName(gqlType));
        selection.setNonNullable(QueryTraversal.isNonNull(gqlType) || QueryTraversal.isTypename(name));
        selection.setNonNullableElements(this.isNonNullableElements(gqlType));
        selection.setCollection(QueryTraversal.isMultiValue(gqlType));
        selection.setDefinedIn(parentType);
        selection.setDefinedInType(this.control.getObject(parentType));
        this.path.add(selection.getResponseName());
        selection.setSelections(this.readSelectionSet(field.getSelectionSet(), gqlType));
        Shape shape = selection.getDefinedInType();
        selection.setArguments(this.getReadArguments(field, shape, OperationType.QUERY));
        selection.setLocation(this.copySourceLocation((AbstractNode<?>)field));
        selection.setRangeCheck(this.isRangeCheck(parentType, name));
        this.path.removeLast();
        return selection;
    }

    private boolean isNonNullableElements(GraphQLSchemaElement gqlType) {
        GraphQLSchemaElement type = gqlType;
        while (QueryTraversal.isMultiValue(type)) {
            if (type instanceof GraphQLFieldDefinition) {
                type = ((GraphQLFieldDefinition)type).getType();
            }
            type = GraphQLTypeUtil.unwrapOne((GraphQLType)((GraphQLType)type));
        }
        return QueryTraversal.isNonNull(type);
    }

    private Arguments getReadArguments(Field field, Shape shape, OperationType query) {
        try {
            return this.argumentReader.read(this.control.getGraphQlSchema(), query, field, shape, this.path, this.endpointBuilder);
        }
        catch (InvalidOperationException ioe) {
            this.graphQlErrors.addAll(ioe.getErrors());
            return new Arguments();
        }
    }

    private static boolean isTypename(String name) {
        return "__typename".equals(name);
    }

    private boolean isRangeCheck(String type, String field) {
        if (field.startsWith("__")) {
            if (!QueryTraversal.isTypename(field)) {
                throw new IllegalArgumentException("The following field is not supported: " + field);
            }
            return false;
        }
        Shape shape = this.control.getObject(type);
        if (shape == null) {
            return false;
        }
        PropertyShape property = shape.getProperty(this.getActualProperty(type, field)).orElse(null);
        if (property != null && null != property.getRangeCheck()) {
            return property.getRangeCheck();
        }
        return false;
    }

    private String getActualProperty(String type, String field) {
        if ("name".equals(field)) {
            return this.control.getObject(type).getName();
        }
        return field;
    }

    private com.ontotext.models.query.SourceLocation copySourceLocation(AbstractNode<?> argument) {
        SourceLocation sourceLocation = argument.getSourceLocation();
        if (sourceLocation != null) {
            return new com.ontotext.models.query.SourceLocation(sourceLocation.getLine(), sourceLocation.getColumn());
        }
        return null;
    }

    private static boolean isNonNull(GraphQLSchemaElement graphQlType) {
        GraphQLSchemaElement type = graphQlType;
        if (type instanceof GraphQLFieldDefinition) {
            type = ((GraphQLFieldDefinition)type).getType();
        }
        return type instanceof GraphQLNonNull;
    }

    private static boolean isMultiValue(GraphQLSchemaElement graphQlType) {
        GraphQLSchemaElement type = graphQlType;
        if (type instanceof GraphQLFieldDefinition) {
            type = ((GraphQLFieldDefinition)type).getType();
        }
        while (type instanceof GraphQLModifiedType) {
            if (type instanceof GraphQLList) {
                return true;
            }
            type = ((GraphQLModifiedType)type).getWrappedType();
        }
        return false;
    }

    private static Function<String, GraphQLSchemaElement> resolveType(GraphQLSchemaElement parentType) {
        GraphQLSchemaElement actualParentType = QueryTraversal.getActualType(parentType);
        return name -> {
            if (name.startsWith("__")) {
                if (!QueryTraversal.isTypename(name)) {
                    throw new IllegalArgumentException("The following field is not supported: " + name);
                }
                return Scalars.GraphQLString;
            }
            if (actualParentType instanceof GraphQLObjectType) {
                return ((GraphQLObjectType)actualParentType).getFieldDefinition(name);
            }
            return actualParentType.getChildren().stream().filter(t -> QueryTraversal.getFieldName(t).equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such type '" + name + "' is defined"));
        };
    }

    private static String getFieldName(GraphQLSchemaElement type) {
        while (type instanceof GraphQLModifiedType) {
            type = ((GraphQLModifiedType)type).getWrappedType();
        }
        return ((GraphQLNamedSchemaElement)type).getName();
    }

    private GraphQLSchemaElement getQueryActualType(Field field) {
        GraphQLObjectType queryType = this.control.getGraphQlSchema().getQueryType();
        GraphQLFieldDefinition fieldDefinition = queryType.getFieldDefinition(field.getName());
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("No such query: " + field.getName());
        }
        return QueryTraversal.getActualType((GraphQLSchemaElement)fieldDefinition.getType());
    }

    private static String getTypeName(GraphQLSchemaElement type) {
        return ((GraphQLNamedType)QueryTraversal.getActualType(type)).getName();
    }

    private static GraphQLSchemaElement getActualType(GraphQLSchemaElement graphQlType) {
        GraphQLSchemaElement type = graphQlType;
        if (type instanceof GraphQLFieldDefinition) {
            type = ((GraphQLFieldDefinition)type).getType();
        }
        while (type instanceof GraphQLModifiedType) {
            type = ((GraphQLModifiedType)type).getWrappedType();
        }
        return type;
    }

    private GraphQLSchemaElement getMutationParentType(Field field) {
        GraphQLType objectType;
        String fieldName = this.getMutationNameStrippedOfPfx(field.getName());
        if (fieldName.contains("_") && (objectType = this.control.getGraphQlSchema().getType(fieldName.split("_", 2)[1])) != null) {
            return QueryTraversal.getActualType((GraphQLSchemaElement)objectType);
        }
        return this.getMutationResponseType(field);
    }

    private GraphQLSchemaElement getMutationResponseType(Field field) {
        GraphQLOutputType responseType = this.control.getGraphQlSchema().getMutationType().getFieldDefinition(field.getName()).getType();
        return QueryTraversal.getActualType((GraphQLSchemaElement)responseType);
    }

    private String getMutationNameStrippedOfPfx(String mutationName) {
        Optional pfx = this.control.getSomlSchema().getConfig().getMutationPfx();
        return pfx.isPresent() ? mutationName.replaceFirst((String)pfx.get(), "") : mutationName;
    }

    static {
        MUTATION_FACTORY.put(CREATE_PREFIX, CreateMutation::new);
        MUTATION_FACTORY.put(UPDATE_PREFIX, UpdateMutation::new);
        MUTATION_FACTORY.put(DELETE_PREFIX, DeleteMutation::new);
    }
}

