/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.graphql.parser.SelectionBuilder;
import com.ontotext.graphql.parser.argument.ArgumentConverter;
import com.ontotext.graphql.parser.argument.ArgumentConverterAware;
import com.ontotext.graphql.parser.argument.optimization.FilterExpressionOptimizer;
import com.ontotext.graphql.parser.argument.optimization.LiteralValueAndLangOptimization;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.Node;
import com.ontotext.rbac.SecurityContext;

@Order(value=800)
public class LangStringFilterPostProcessor
implements OperationPostProcessor,
ArgumentConverterAware {
    private InputValueConverter valueConverter;

    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        this.createWhereSelection((Selectable)operation, new SelectionBuilder(operation.getSchema()));
    }

    private void createWhereSelection(Selectable selectable, SelectionBuilder selectionBuilder) {
        Arguments arguments = selectable.getArguments();
        arguments.getLangFilter().ifPresent(exp -> this.addLiteralSelection(selectable, "lang", selectionBuilder));
        arguments.getLangValueFilter().ifPresent(exp -> this.addLiteralSelection(selectable, "value", selectionBuilder));
        this.combineLangFilters(arguments, selectable);
        selectable.getSelections().forEach(selectable1 -> this.createWhereSelection((Selectable)selectable1, selectionBuilder));
    }

    private void addLiteralSelection(Selectable selectable, String property, SelectionBuilder selectionBuilder) {
        if (selectable.getWhereSelections().stream().noneMatch(Selectable.byName((String)property))) {
            selectionBuilder.addWhereSelection(property, "Literal", selectable).get();
        }
    }

    private void combineLangFilters(Arguments arguments, Selectable selectable) {
        Node resultFilter;
        if (arguments.getWhere().isPresent()) {
            return;
        }
        LangFilter langFilter = arguments.getLangFilter().orElse(null);
        Node langValueFilter = arguments.getLangValueFilter().orElse(null);
        if (langFilter == null && langValueFilter == null) {
            return;
        }
        if (langFilter != null) {
            if (langValueFilter != null) {
                SomlSchema somlSchema = selectable.getDefinedInType().getContainedIn().getContainedIn();
                Shape shape = (Shape)somlSchema.getObjects().get((Object)selectable.getType());
                PropertyShape propertyShape = (PropertyShape)selectable.getProperty().orElseThrow(IllegalStateException::new);
                resultFilter = ExpressionsFactory.node((String)selectable.getName(), (Shape)shape, (PropertyShape)propertyShape).append((ExpressionTerm)langFilter.getExpression()).append((ExpressionTerm)langValueFilter);
            } else {
                resultFilter = langFilter.getExpression();
                assert (resultFilter != null) : "The lang filter is missing an expression. Used wrong lang filter parser";
            }
        } else {
            resultFilter = langValueFilter;
        }
        resultFilter = this.applyValueAndLangOptimization((ExpressionValue<?>)resultFilter);
        arguments.setWhere(resultFilter);
    }

    private ExpressionValue<?> applyValueAndLangOptimization(ExpressionValue<?> expressionValue) {
        FilterExpressionOptimizer optimizer = new FilterExpressionOptimizer();
        optimizer.addOptimization(new LiteralValueAndLangOptimization(this.valueConverter));
        ExpressionValue result = optimizer.optimize(expressionValue, null);
        if (result instanceof Node && !((Node)result).getName().equals("lang") && !((Node)result).getName().equals("value")) {
            return (ExpressionValue)result.getValue();
        }
        return result;
    }

    @Override
    public void setArgumentConverter(ArgumentConverter argumentConverter) {
        this.valueConverter = argumentConverter.getValueConverter();
    }
}

