/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Order(value=750)
public class FragmentUnionGeneratorPostProcessor
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (!operation.getSchema().getObjects().containsKey((Object)operation.getType())) {
            return;
        }
        this.processSelectionsTree((Selectable)operation);
    }

    private void processSelectionsTree(Selectable selectable) {
        if (selectable.isComplexType() && selectable.isQueryable()) {
            for (Selectable selection : new ArrayList(selectable.getSelections())) {
                this.processSelectionsTree(selection);
                this.generateFragmentsIfNeeded(selectable);
            }
        }
    }

    private void generateFragmentsIfNeeded(Selectable selectable) {
        if (selectable instanceof Operation) {
            return;
        }
        if (selectable.getShapeType().filter(Shape::isUnion).isEmpty()) {
            return;
        }
        Map<String, List<Selectable>> groupByFragment = selectable.getSelections().stream().collect(Collectors.groupingBy(current -> current.getDefinedInType().getId()));
        if (groupByFragment.size() == 1) {
            return;
        }
        Shape range = (Shape)selectable.getShapeType().orElseThrow();
        if (groupByFragment.containsKey(range.getId())) {
            if (groupByFragment.size() == 2) {
                return;
            }
            groupByFragment.remove(range.getId());
        }
        List copies = IntStream.range(0, groupByFragment.size()).mapToObj(idx -> ((Selection)selectable).deepCopy()).collect(Collectors.toList());
        ((Selection)selectable).setTreeAsNoneQueryable();
        Selectable parent = selectable.getParent();
        int index = parent.getSelections().indexOf(selectable);
        List orderedTypes = selectable.getSelections().stream().map(current -> current.getDefinedInType().getId()).distinct().collect(Collectors.toList());
        orderedTypes.remove(range.getId());
        assert (orderedTypes.size() == copies.size());
        for (int i = 0; i < orderedTypes.size(); ++i) {
            String type = (String)orderedTypes.get(i);
            Selection copy = (Selection)copies.get(i);
            copy.getSelections().removeIf(selection -> !selection.getDefinedInType().getId().equals(type) && !selection.getDefinedInType().getId().equals(range.getId()));
            copy.setRequestedByUser(false);
            parent.getSelections().add(++index, copy);
        }
    }
}

