/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.parser;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Operation;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Query;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.plugin.Order;

@Order(value=160)
public class FederatedServiceAssigner
implements OperationPostProcessor {
    @Override
    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (!(operation instanceof Query)) {
            return;
        }
        this.addServiceIfNeeded((Selectable)operation);
    }

    private void addServiceIfNeeded(Selectable selectable) {
        if (selectable instanceof Query) {
            Query query = (Query)selectable;
            this.handleQuery(query);
        } else if (selectable instanceof Selection) {
            this.handleSelection(selectable);
        }
        for (Selectable selection : selectable.getSelections()) {
            this.addServiceIfNeeded(selection);
        }
        for (Selectable selection : selectable.getWhereSelections()) {
            this.addServiceIfNeeded(selection);
        }
    }

    private void handleQuery(Query query) {
        Shape shape = query.getReturnTypeInstance();
        if (shape.getServiceAddress() != null) {
            query.setService(shape.getServiceAddress());
        }
    }

    private void handleSelection(Selectable selectable) {
        String service = null;
        if (this.isComplexOrWhereWithSubSelects(selectable)) {
            Shape shape = selectable.getShapeType().orElse(null);
            if (shape != null) {
                service = shape.getServiceAddress();
            }
        } else {
            service = this.isSelectableInverseAlias(selectable) ? ((PropertyShape)selectable.getProperty().orElseThrow(RuntimeException::new)).getRangeShape().getServiceAddress() : (selectable.hasDomainConstraints() ? ((Shape)selectable.getDomainConstraints().getFirst()).getServiceAddress() : (selectable.isInFragment() ? selectable.getDefinedInType().getServiceAddress() : selectable.getParent().getService()));
        }
        if (service != null) {
            ((Selection)selectable).setService(service);
        }
    }

    private boolean isComplexOrWhereWithSubSelects(Selectable selectable) {
        return selectable.isComplexType() && !"Literal".equals(selectable.getType()) || !selectable.getWhereSelections().isEmpty();
    }

    private boolean isSelectableInverseAlias(Selectable selectable) {
        PropertyShape prop = selectable.getProperty().orElse(null);
        if (prop != null) {
            return prop.getInverseAlias() != null;
        }
        return false;
    }
}

