/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.ontotext.graphql.responder.GraphQlResponder;
import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.Operation;
import com.ontotext.models.query.QueryParserFactory;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.QueryBuilderFactory;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.IntrospectionCacheConfig;
import com.ontotext.soaas.query.DynamicEndpointProvider;
import com.ontotext.soaas.query.monitoring.QueryMeter;
import com.ontotext.soaas.query.service.CachingRequestHandler;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.GraphQlRequestHandler;
import com.ontotext.soaas.query.service.IntrospectionRequestHandler;
import com.ontotext.soaas.query.service.QueryRequestHandler;
import com.ontotext.soaas.query.service.QueryService;
import com.ontotext.soaas.query.service.RequestConfig;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoaasQueryService
implements QueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String boundSchemaId;
    private boolean initialized = false;
    private GraphQlRequestHandler introspectionRequestHandler;
    private GraphQlRequestHandler queryRequestHandler;
    private final GraphQlResponder graphQlResponder;
    private final BoundServiceState schemaManager;
    private final QueryBuilderFactory<Operation> queryBuilderFactorySupplier;
    private final DynamicEndpointProvider endpointProvider;
    private final QueryParserFactory queryParserFactory;
    private final QueryMeter queryMeter;
    private final GraphqlOptions graphqlOptions;
    private final OperationBuilderOptions operationBuilderOptions;
    private final SecurityContext securityContext;

    public SoaasQueryService(GraphQlResponder graphQlResponder, BoundServiceState schemaManager, QueryBuilderFactory<Operation> queryBuilderFactorySupplier, DynamicEndpointProvider endpointProvider, QueryParserFactory queryParserFactory, QueryMeter queryMeter, GraphqlOptions graphqlOptions, OperationBuilderOptions operationBuilderOptions, SecurityContext securityContext) {
        this.graphQlResponder = graphQlResponder;
        this.schemaManager = schemaManager;
        this.queryBuilderFactorySupplier = queryBuilderFactorySupplier;
        this.endpointProvider = endpointProvider;
        this.queryParserFactory = queryParserFactory;
        this.queryMeter = queryMeter;
        this.graphqlOptions = graphqlOptions;
        this.operationBuilderOptions = operationBuilderOptions;
        this.securityContext = securityContext;
        if (schemaManager instanceof SomlSchemaManager) {
            SomlSchemaManager manager = (SomlSchemaManager)schemaManager;
            manager.registerSchemaBindListener(updated -> this.reInitialize());
            manager.registerSchemaChangeListener(updated -> this.reInitialize());
            manager.registerSchemaRemovedListener(oldSoml -> this.onSchemaRemoved());
        }
    }

    @Override
    public String getSchemaId() {
        this.initialize();
        return this.boundSchemaId;
    }

    @Override
    public Object evaluateQuery(GraphQlQueryRequest queryRequest, RequestConfig requestConfig) {
        this.initialize();
        if (this.introspectionRequestHandler.accept(queryRequest)) {
            return this.introspectionRequestHandler.handleRequest(queryRequest, requestConfig);
        }
        return this.queryRequestHandler.handleRequest(queryRequest, requestConfig);
    }

    @Override
    public void shutdown() {
        this.cleanUp();
        this.initialized = false;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void onSchemaRemoved() {
        LOGGER.info("Deactivating service for removed schema: {}", (Object)this.boundSchemaId);
        this.initialized = false;
    }

    private void reInitialize() {
        LOGGER.info("Deactivating service for updated bound schema: {}", (Object)this.boundSchemaId);
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.isInitialized()) {
            return;
        }
        try {
            SomlSchemaManager manager;
            BoundServiceState boundServiceState = this.schemaManager;
            if (boundServiceState instanceof SomlSchemaManager && !(manager = (SomlSchemaManager)boundServiceState).hasBoundSchema()) {
                throw new PlatformConfigurationException("No SOML bound to the SOaaS instance!", ErrorCode.SOML_NOT_BOUND);
            }
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not load SOML, due to: " + use.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
        }
        SoaasQueryService soaasQueryService = this;
        synchronized (soaasQueryService) {
            if (this.isInitialized()) {
                return;
            }
            this.cleanUp();
            this.reloadSchema();
            this.initialized = true;
            LOGGER.info("Activating service for schema: {}", (Object)this.boundSchemaId);
        }
    }

    private void cleanUp() {
        this.boundSchemaId = null;
        GraphQlRequestHandler graphQlRequestHandler = this.introspectionRequestHandler;
        if (graphQlRequestHandler instanceof CachingRequestHandler) {
            CachingRequestHandler introspectionHandler = (CachingRequestHandler)graphQlRequestHandler;
            introspectionHandler.clearAll();
        }
        this.introspectionRequestHandler = null;
        this.queryRequestHandler = null;
    }

    private void reloadSchema() {
        this.queryRequestHandler = new QueryRequestHandler(this.graphQlResponder, this.endpointProvider, this.queryBuilderFactorySupplier, this.schemaManager, this.queryParserFactory, this.queryMeter, this.graphqlOptions, this.operationBuilderOptions, this.securityContext);
        this.introspectionRequestHandler = new IntrospectionRequestHandler(this.schemaManager.getGraphQlSchema());
        if (this.graphqlOptions.getIntrospectionQueryCache().isEnabled()) {
            IntrospectionCacheConfig cacheConfig = this.graphqlOptions.getIntrospectionQueryCache();
            this.introspectionRequestHandler = new CachingRequestHandler(this.introspectionRequestHandler, this.schemaManager.getSomlSchema().getId(), cacheConfig.getConfig(), cacheConfig.getLocation(), cacheConfig.isSanitizeQuery());
        }
        this.boundSchemaId = this.schemaManager.getSomlSchema().getId();
    }
}

