/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import java.util.Objects;

public class RequestConfig {
    public static final String NAME = "requestConfig";
    private final String acceptType;
    private final String acceptLanguage;
    private final boolean healthCheckRequest;
    private boolean isLoggingDisabled;

    public RequestConfig(String acceptType, String acceptLanguage, boolean healthCheckRequest, boolean isLoggingDisabled) {
        this.acceptType = acceptType;
        this.acceptLanguage = acceptLanguage;
        this.healthCheckRequest = healthCheckRequest;
        this.isLoggingDisabled = isLoggingDisabled;
    }

    public RequestConfig(String acceptType, String acceptLanguage) {
        this(acceptType, acceptLanguage, false, true);
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestConfig)) {
            return false;
        }
        RequestConfig that = (RequestConfig)obj;
        return Objects.equals(this.acceptType, that.acceptType) && Objects.equals(this.acceptLanguage, that.acceptLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.acceptType, this.acceptLanguage);
    }

    public String toString() {
        return String.format("{Accept: '%s', Accept-Language: '%s'}", this.acceptType, this.acceptLanguage);
    }

    public boolean isHealthCheckRequest() {
        return this.healthCheckRequest;
    }

    public boolean isLoggingDisabled() {
        return this.isLoggingDisabled;
    }

    public void setLoggingDisabled(boolean loggingDisabled) {
        this.isLoggingDisabled = loggingDisabled;
    }
}

