/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.ontotext.graphql.compiler.GraphQlToSparqlConverter;
import com.ontotext.graphql.parser.argument.optimization.StatisticsCollector;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.graphql.responder.BaseExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.GraphQlResponder;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.graphql.responder.Responder;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.licensecheck.GraphQlExtendedFeatures;
import com.ontotext.licensecheck.LicenseCheckUtil;
import com.ontotext.licensecheck.LicenseRestrictionException;
import com.ontotext.metamodel.BoundServiceState;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.SomlBindException;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.OperationValidators;
import com.ontotext.models.Rbac;
import com.ontotext.models.Roles;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.ValidationResult;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGeneratorOptions;
import com.ontotext.models.mutation.data.generation.DataGenerators;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.QueryParser;
import com.ontotext.models.query.QueryParserFactory;
import com.ontotext.models.query.Variables;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.util.RolesProviderUtil;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.connection.EndpointBuilder;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.PlatformQueryExecutionException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.sparql.CompilationResult;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.QueryBuilderFactory;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import com.ontotext.soaas.configuration.DataGeneratorConfigOptions;
import com.ontotext.soaas.configuration.GraphqlOptions;
import com.ontotext.soaas.configuration.MutationConfigurations;
import com.ontotext.soaas.configuration.ValidatorConfigOptions;
import com.ontotext.soaas.proxies.TimeTrackingResponder;
import com.ontotext.soaas.query.DynamicEndpointProvider;
import com.ontotext.soaas.query.monitoring.QueryMeter;
import com.ontotext.soaas.query.monitoring.TimeSample;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.GraphQlRequestHandler;
import com.ontotext.soaas.query.service.RequestConfig;
import graphql.GraphQLError;
import graphql.GraphQLException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestHandler
implements GraphQlRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Logger QUERY_LOGGER = Loggers.sparqlQueryLogger();
    private final QueryParser queryParser;
    private final GraphQlToSparqlConverter gqlToSparqlConverter;
    private final GraphQlResponder graphQlResponder;
    private final BoundServiceState schemaManager;
    private final DynamicEndpointProvider endpointProvider;
    private final QueryParserFactory queryParserFactory;
    private final QueryMeter queryMeter;
    private final GraphqlOptions graphqlOptions;
    private final OperationBuilderOptions operationBuilderOptions;
    private final SecurityContext securityContext;
    private final OperationValidators operationValidators = new OperationValidators();
    private final DataGenerators dataGenerators = new DataGenerators();

    QueryRequestHandler(GraphQlResponder graphQlResponder, DynamicEndpointProvider endpointProvider, QueryBuilderFactory<Operation> queryBuilderFactorySupplier, BoundServiceState schemaManager, QueryParserFactory queryParserFactory, QueryMeter queryMeter, GraphqlOptions graphqlOptions, OperationBuilderOptions operationBuilderOptions, SecurityContext securityContext) {
        this.graphQlResponder = graphQlResponder;
        this.endpointProvider = endpointProvider;
        this.schemaManager = schemaManager;
        this.queryParserFactory = queryParserFactory;
        this.queryMeter = queryMeter;
        this.graphqlOptions = graphqlOptions;
        this.operationBuilderOptions = operationBuilderOptions;
        this.securityContext = securityContext;
        this.queryParser = this.getParser();
        this.gqlToSparqlConverter = new GraphQlToSparqlConverter(queryBuilderFactorySupplier);
    }

    private QueryParser getParser() {
        QueryParser parser;
        try {
            parser = this.queryParserFactory.createParser();
        }
        catch (SomlBindException | PlatformConfigurationException pce) {
            LOGGER.error("Could not initialize service due to configuration problem. Resolve the problem in order to access the service: {}:{}", (Object)pce.getErrorCode().getCode(), (Object)pce.getMessage());
            throw pce;
        }
        return parser;
    }

    @Override
    @NotNull
    public Object handleRequest(GraphQlQueryRequest queryRequest, RequestConfig requestConfig) {
        this.checkIfResponseFormatIsSupported(requestConfig);
        this.checkIfLicenseIsRequired();
        ValidationResult validationResult = new ValidationResult();
        List<Operation> parsedQueries = this.parseQuery(queryRequest, validationResult, requestConfig);
        String operationName = queryRequest.getOperationName().orElse(null);
        List<CompilationResult> sparqlQueries = this.compileQueries(parsedQueries, operationName);
        boolean isQueryRequest = parsedQueries.stream().map(Operation::getOperationType).allMatch(operation -> operation == OperationType.QUERY || operation == OperationType.SUBSCRIPTION || operation == OperationType.INFO);
        if (isQueryRequest) {
            return this.executeQuery(parsedQueries, sparqlQueries, requestConfig, operationName, validationResult);
        }
        return this.executeMutation(parsedQueries, sparqlQueries, requestConfig, operationName, validationResult);
    }

    private void checkIfLicenseIsRequired() {
        LinkedList<GraphQlExtendedFeatures> features = new LinkedList<GraphQlExtendedFeatures>();
        if (this.schemaManager.getSomlSchema().hasUserDefinedRbac()) {
            features.add(GraphQlExtendedFeatures.RBAC);
        }
        if (this.schemaManager.getSomlSchema().hasFederatedService()) {
            features.add(GraphQlExtendedFeatures.SPARQL_FEDERATION);
        }
        if (!features.isEmpty()) {
            try {
                LicenseCheckUtil.requireGraphQlExtendedLicense((GraphQlExtendedFeatures[])((GraphQlExtendedFeatures[])features.toArray(GraphQlExtendedFeatures[]::new)));
            }
            catch (LicenseRestrictionException e) {
                throw new PlatformQueryExecutionException(200, Map.of("errors", List.of(Map.of("message", e.getMessage()))), List.of(e.getMessage()));
            }
        }
    }

    private void checkIfResponseFormatIsSupported(RequestConfig requestConfig) {
        if (!this.graphQlResponder.isSupported(requestConfig.getAcceptType())) {
            throw new PlatformConfigurationException("Unsupported response format: " + requestConfig.getAcceptType(), ErrorCode.BAD_MIME_TYPE);
        }
    }

    private List<Operation> parseQuery(GraphQlQueryRequest queryRequest, ValidationResult validationResult, RequestConfig requestConfig) {
        List<Operation> parsedQueries = Collections.emptyList();
        String operationName = queryRequest.getOperationName().orElse(null);
        try {
            parsedQueries = this.parseOperations(queryRequest, requestConfig, validationResult);
            operationName = queryRequest.getOperationName().orElse(operationName);
            this.doDataGeneration(parsedQueries, operationName, validationResult);
            if (!requestConfig.isHealthCheckRequest()) {
                this.doValidation(parsedQueries, operationName, validationResult);
            }
        }
        catch (GraphQLException gqlError) {
            parsedQueries.forEach(Operation::invalidate);
            validationResult.addErrorResponse((Serializable)((Object)gqlError.getMessage()));
        }
        catch (InvalidOperationException iqEx) {
            for (GraphQLError error : iqEx.getErrors()) {
                LOGGER.error(error.getMessage());
            }
            iqEx.getErrors().stream().map(GraphQLError::toSpecification).map(err -> (Serializable)((Object)err)).forEach(arg_0 -> ((ValidationResult)validationResult).addErrorResponse(arg_0));
            parsedQueries.forEach(Operation::invalidate);
        }
        return parsedQueries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Operation> parseOperations(GraphQlQueryRequest queryRequest, RequestConfig requestConfig, ValidationResult validationResult) {
        TimeSample parseTimer = this.queryMeter.startSample();
        try {
            Variables variables = QueryRequestHandler.createVariables(queryRequest, requestConfig, validationResult);
            String operationName = queryRequest.getOperationName().orElse(null);
            List operations = this.queryParser.parse((Object)queryRequest.getQuery(), operationName, variables, (EndpointBuilder)this.endpointProvider, this.securityContext);
            if (StringUtils.isBlank((CharSequence)operationName)) {
                operations.stream().findFirst().ifPresent(operation -> queryRequest.setOperationName(Objects.requireNonNullElse(operation.getRequestOperationName(), operation.getName())));
            }
            List list = operations;
            return list;
        }
        finally {
            this.queryMeter.trackQueryParsing(parseTimer, (String)queryRequest.getOperationName().orElse(null));
        }
    }

    @NotNull
    private static Variables createVariables(GraphQlQueryRequest queryRequest, RequestConfig requestConfig, ValidationResult validationResult) {
        Map userVars = queryRequest.getVariables().orElse(Collections.emptyMap());
        Variables variables = new Variables(userVars);
        String acceptLanguage = StringUtils.trimToNull((String)requestConfig.getAcceptLanguage());
        if (acceptLanguage != null) {
            try {
                acceptLanguage = LangFilter.convertAcceptLanguageToInternalFormat((String)acceptLanguage);
                variables.setAcceptLanguage(acceptLanguage);
            }
            catch (IllegalArgumentException iae) {
                OperationResponse response = new OperationResponse();
                response.addWarningMessage((Serializable)((Object)("Ignored invalid value of the Accept-Language HTTP header: " + iae.getMessage())));
                validationResult.addResponse(response);
            }
        }
        return variables;
    }

    private void doDataGeneration(List<Operation> parsedQueries, String operationName, ValidationResult validationResult) {
        MutationConfigurations mutationConfigurations = this.graphqlOptions.getMutation();
        DataGeneratorConfigOptions generationConfig = mutationConfigurations.getGeneration();
        if (mutationConfigurations.isEnabled() && generationConfig.isEnabled()) {
            TimeSample dataGenerationTimer = this.queryMeter.startSample();
            SomlSchema somlSchema = this.schemaManager.getSomlSchema();
            DataGenerationContext generationCtx = new DataGenerationContext(somlSchema, (DataGeneratorOptions)generationConfig).setData(new HashMap());
            generationCtx.getData().put("roles", this.getEffectiveUserRoles(somlSchema.getRbac()));
            this.dataGenerators.generate(parsedQueries, generationCtx, validationResult);
            this.queryMeter.trackDataGenrating(dataGenerationTimer, operationName);
        }
    }

    private void doValidation(List<Operation> parsedQueries, String operationName, ValidationResult validationResult) {
        ValidatorConfigOptions validationConfig = this.graphqlOptions.getValidation();
        if (validationConfig.isEnabled()) {
            TimeSample validateTimer = this.queryMeter.startSample();
            List validationResponses = parsedQueries.stream().map(operation -> {
                OperationResponse response = this.operationValidators.validate(operation, this.createValidationContext((Operation)operation));
                if (!response.isValid()) {
                    LOGGER.warn("Operation '{}' would not be evaluated due to validation failures: {}", (Object)operation.getResponseName(), (Object)response.getErrorMessages());
                    operation.invalidate();
                }
                return response;
            }).collect(Collectors.toList());
            validationResult.addResponses(validationResponses);
            this.queryMeter.trackQueryValidating(validateTimer, operationName);
        }
    }

    private ValidationContext createValidationContext(Operation operation) {
        ValidatorConfigOptions validationConfig = this.graphqlOptions.getValidation();
        Endpoint endpoint = this.getEndpoint(operation, false);
        SomlSchema somlSchema = this.schemaManager.getSomlSchema();
        ValidationContext validationCtx = new ValidationContext(somlSchema, this.getEffectiveUserRoles(somlSchema.getRbac()), RolesProviderUtil.getRoles((SecurityContext)this.securityContext), (ValidatorOptions)validationConfig);
        validationCtx.getData().put(StatisticsCollector.class.getSimpleName(), this.endpointProvider.getEndpointStatistics().getStatisticsCollector(endpoint));
        return validationCtx;
    }

    private Set<Role> getEffectiveUserRoles(Rbac rbac) {
        return RolesProviderUtil.getEffectiveUserRoles((SecurityContext)this.securityContext, (Roles)rbac.getRoles()).stream().map(role -> new Role(role.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<CompilationResult> compileQueries(List<Operation> parsedQueries, String operationName) {
        TimeSample compileTimer = this.queryMeter.startSample();
        List<CompilationResult> sparqlQueries = parsedQueries.stream().map(this::compileQuery).collect(Collectors.toList());
        this.queryMeter.trackQueryCompiling(compileTimer, operationName);
        return sparqlQueries;
    }

    private CompilationResult compileQuery(Operation operation) {
        CompilationResult compilationResult = null;
        if (operation != null) {
            LOGGER.debug("Validated Operation:\n{}", (Object)operation);
            compilationResult = this.gqlToSparqlConverter.convert(operation);
            LOGGER.debug("Query to {} SPARQL", (Object)compilationResult.getSteps().size());
        }
        return compilationResult;
    }

    private Object executeQuery(List<Operation> parsedQueries, List<CompilationResult> sparqlQueries, RequestConfig requestConfig, String operationName, ValidationResult validationResult) {
        assert (parsedQueries.size() == sparqlQueries.size());
        QueryExecutionRequest executionContext = new QueryExecutionRequest(this.schemaManager.getSomlSchema());
        if (!parsedQueries.isEmpty() && !sparqlQueries.isEmpty()) {
            for (int i = 0; i < parsedQueries.size(); ++i) {
                Operation parsedQuery = parsedQueries.get(i);
                CompilationResult compilationResult = sparqlQueries.get(i);
                executionContext.addQuery(parsedQuery, this.toQuerySteps(compilationResult), this.getEndpoint(parsedQuery, requestConfig.isHealthCheckRequest()));
            }
        }
        if (validationResult.hasErrors()) {
            executionContext.addErrors(validationResult.getErrors());
        }
        if (validationResult.hasWarnings()) {
            executionContext.addWarnings(validationResult.getWarnings());
        }
        this.configureLogging(requestConfig, (BaseExecutionRequest<?>)executionContext);
        return this.executeRequest(operationName, (ExecutionRequest<?>)executionContext, requestConfig.getAcceptType());
    }

    private Endpoint getEndpoint(Operation parsedQuery, boolean healthCheckRequest) {
        return this.endpointProvider.getEndpoint(parsedQuery, healthCheckRequest);
    }

    private Object executeMutation(List<Operation> parsedOperations, List<CompilationResult> sparqlQueries, RequestConfig requestConfig, String operationName, ValidationResult validationResult) {
        assert (parsedOperations.size() == sparqlQueries.size());
        SomlSchema somlSchema = this.schemaManager.getSomlSchema();
        ShaclSchema shaclSchema = this.schemaManager instanceof SomlSchemaManager ? ((SomlSchemaManager)this.schemaManager).useUnrestricted().getShaclSchema() : this.schemaManager.getShaclSchema();
        MutationExecutionRequest executionContext = new MutationExecutionRequest(somlSchema, shaclSchema, this.getEffectiveUserRoles(somlSchema.getRbac()), (ValidatorOptions)this.graphqlOptions.getValidation(), this.operationBuilderOptions);
        executionContext.setHealthRequest(requestConfig.isHealthCheckRequest());
        if (!parsedOperations.isEmpty() && !sparqlQueries.isEmpty()) {
            for (int i = 0; i < parsedOperations.size(); ++i) {
                Operation operation = parsedOperations.get(i);
                if (!(operation instanceof Mutation)) {
                    throw new IllegalArgumentException("Should set only a mutation as operation");
                }
                CompilationResult compilationResult = sparqlQueries.get(i);
                List<UpdateStep> updates = this.toUpdateSteps(compilationResult);
                List<QueryStep> querySteps = this.toQuerySteps(compilationResult);
                executionContext.addOperation((Mutation)operation, updates, querySteps, this.getEndpoint(operation, requestConfig.isHealthCheckRequest()));
            }
        }
        if (validationResult.hasErrors()) {
            executionContext.addErrors(validationResult.getErrors());
        }
        if (validationResult.hasWarnings()) {
            executionContext.addWarnings(validationResult.getWarnings());
        }
        this.configureLogging(requestConfig, (BaseExecutionRequest<?>)executionContext);
        return this.executeRequest(operationName, (ExecutionRequest<?>)executionContext, requestConfig.getAcceptType());
    }

    private void configureLogging(RequestConfig requestConfig, BaseExecutionRequest<?> executionContext) {
        if (requestConfig.isHealthCheckRequest()) {
            executionContext.setSilent(true);
        }
        if (this.graphqlOptions.isEnableQueryLogging()) {
            executionContext.setSilent(false);
            return;
        }
        executionContext.setSilent(requestConfig.isLoggingDisabled() && !QUERY_LOGGER.isDebugEnabled());
    }

    private Object executeRequest(String operationName, ExecutionRequest<?> executionContext, String mimeType) {
        return new TimeTrackingResponder((Responder)this.graphQlResponder, this.queryMeter, operationName).execute(executionContext, mimeType);
    }

    private List<UpdateStep> toUpdateSteps(CompilationResult compilationResult) {
        return compilationResult.getSteps().stream().filter(SparqlExecutionStep::isUpdate).map(this::toUpdateStep).collect(Collectors.toList());
    }

    private UpdateStep toUpdateStep(SparqlExecutionStep executionStep) {
        return new UpdateStep(executionStep.getId(), executionStep.getQuery(null));
    }

    private List<QueryStep> toQuerySteps(CompilationResult compilationResult) {
        return QueryStep.from((List)compilationResult.getSteps());
    }

    @Override
    public boolean accept(GraphQlQueryRequest queryRequest) {
        return true;
    }
}

