/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.soaas.query.service;

import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.GraphQlRequestHandler;
import com.ontotext.soaas.query.service.OntoIntrospectionWithDirectivesSupport;
import com.ontotext.soaas.query.service.RequestConfig;
import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class IntrospectionRequestHandler
implements GraphQlRequestHandler {
    private final GraphQL graphql;

    IntrospectionRequestHandler(GraphQLSchema graphql) {
        LinkedHashSet<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>(graphql.getAdditionalTypes());
        additionalTypes.removeIf(this.healthCheckTypeFilter());
        GraphQLObjectType mutationCopy = IntrospectionRequestHandler.copyType(graphql.getMutationType());
        GraphQLObjectType queryCopy = IntrospectionRequestHandler.copyType(graphql.getQueryType());
        GraphQLSchema introspectionSchema = graphql.transform(builder -> {
            builder.clearAdditionalTypes();
            builder.additionalTypes(additionalTypes);
            builder.query(queryCopy);
            builder.mutation(mutationCopy);
        });
        GraphQLSchema schemaWithDirectives = new OntoIntrospectionWithDirectivesSupport().apply(introspectionSchema);
        this.graphql = GraphQL.newGraphQL((GraphQLSchema)schemaWithDirectives).build();
    }

    private Predicate<GraphQLType> healthCheckTypeFilter() {
        return type -> {
            String typeName = ((GraphQLNamedType)type).getName().toLowerCase();
            return typeName.contains("HealthCheck".toLowerCase());
        };
    }

    private static GraphQLObjectType copyType(GraphQLObjectType sourceType) {
        if (sourceType == null) {
            return null;
        }
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject((GraphQLObjectType)sourceType);
        builder.clearFields();
        sourceType.getFieldDefinitions().stream().filter(IntrospectionRequestHandler.isHealthCheck().negate()).forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0));
        GraphQLObjectType type = builder.build();
        if (type.getFieldDefinitions().isEmpty()) {
            return null;
        }
        return type;
    }

    private static Predicate<GraphQLFieldDefinition> isHealthCheck() {
        String healthType = "HealthCheck".toLowerCase();
        return fieldDefinition -> fieldDefinition.getName().toLowerCase().contains(healthType);
    }

    @Override
    public boolean accept(GraphQlQueryRequest queryRequest) {
        return queryRequest.isIntrospectionRequest();
    }

    @Override
    @NotNull
    public Object handleRequest(GraphQlQueryRequest queryRequest, RequestConfig requestConfig) {
        ExecutionInput.Builder request = ExecutionInput.newExecutionInput().query(queryRequest.getQuery()).variables(queryRequest.getVariables().orElse(Map.of())).operationName((String)queryRequest.getOperationName().orElse(null));
        return this.graphql.execute(request).toSpecification();
    }
}

